/*
 * Decompiled with CFR 0.152.
 */
package de.bsvrz.kex.isis.isis.impl;

import de.bsvrz.kex.isis.isis.BisInterfaceException;
import de.bsvrz.kex.isis.isis.MessQuerschnittInterface;
import de.bsvrz.kex.isis.isis.OrtsReferenzAsbStationierungInterface;
import de.bsvrz.kex.isis.isis.OrtsReferenzStrasseUndBetriebsKilometerInterface;
import de.bsvrz.kex.isis.isis.OrtsReferenzStrassenSegmentUndOffsetInterface;
import de.bsvrz.kex.isis.isis.StrassenSegmentInterface;
import de.bsvrz.kex.isis.isis.impl.MessQuerschnitt;
import de.bsvrz.kex.isis.isis.impl.OrtsReferenzAsbStationierung;
import de.bsvrz.kex.isis.isis.impl.OrtsReferenzStrasseUndBetriebsKilometer;
import de.bsvrz.sys.funclib.bitctrl.modell.netz.NetzReferenzException;
import de.bsvrz.sys.funclib.bitctrl.modell.netz.NetzReferenzen;
import de.bsvrz.sys.funclib.bitctrl.modell.netz.StrassenSegmentUndOffsetOrtsReferenz;
import de.bsvrz.sys.funclib.bitctrl.modell.netz.StrassenSegmentUndOffsetOrtsReferenzInterface;
import de.bsvrz.sys.funclib.bitctrl.modell.verkehr.objekte.MessQuerschnittAllgemein;
import de.bsvrz.sys.funclib.bitctrl.modell.verkehr.objekte.StrassenSegment;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

public class OrtsReferenzStrassenSegmentUndOffset
implements OrtsReferenzStrassenSegmentUndOffsetInterface,
StrassenSegmentInterface {
    private final StrassenSegmentUndOffsetOrtsReferenz modelSegment;

    public OrtsReferenzStrassenSegmentUndOffset(String pidStrassenSegment, long startOffset) throws BisInterfaceException {
        try {
            this.modelSegment = new StrassenSegmentUndOffsetOrtsReferenz(pidStrassenSegment, startOffset);
        }
        catch (NetzReferenzException nre) {
            throw new BisInterfaceException(nre);
        }
    }

    public OrtsReferenzStrassenSegmentUndOffset(StrassenSegmentUndOffsetOrtsReferenzInterface ref) throws BisInterfaceException {
        this(ref.getStrassenSegment().getPid(), ref.getStartOffset());
    }

    public OrtsReferenzAsbStationierungInterface ermittleOrtsReferenzAsbStationierung() throws BisInterfaceException {
        try {
            return new OrtsReferenzAsbStationierung(NetzReferenzen.getInstanz().ermittleOrtsReferenzAsbStationierung((StrassenSegmentUndOffsetOrtsReferenzInterface)this.modelSegment));
        }
        catch (NetzReferenzException e) {
            throw new BisInterfaceException(e);
        }
    }

    public OrtsReferenzStrasseUndBetriebsKilometerInterface ermittleOrtsReferenzStrasseUndBetriebsKilometer() throws BisInterfaceException {
        try {
            return new OrtsReferenzStrasseUndBetriebsKilometer(NetzReferenzen.getInstanz().ermittleOrtsReferenzStrasseUndBetriebsKilometer((StrassenSegmentUndOffsetOrtsReferenzInterface)this.modelSegment));
        }
        catch (NetzReferenzException e) {
            throw new BisInterfaceException(e);
        }
    }

    public Integer getLaengsNeigung() throws BisInterfaceException {
        try {
            return this.modelSegment.getLaengsNeigung();
        }
        catch (NetzReferenzException e) {
            throw new BisInterfaceException(e);
        }
    }

    public StrassenSegment getModelSegment() {
        return this.modelSegment.getStrassenSegment();
    }

    public String getName() {
        return this.modelSegment.getName();
    }

    public String getPid() {
        return this.modelSegment.getPid();
    }

    public long getStartOffset() {
        return this.modelSegment.getStartOffset();
    }

    public StrassenSegmentInterface getStrassenSegment() {
        return this;
    }

    public MessQuerschnittInterface getZuflussMessQuerschnitt() throws BisInterfaceException {
        List mqs = this.modelSegment.getStrassenSegment().getMessquerschnitte();
        ArrayList<MessQuerschnittAllgemein> aufsegment = new ArrayList<MessQuerschnittAllgemein>();
        MessQuerschnittAllgemein foundmq = null;
        for (MessQuerschnittAllgemein mq : mqs) {
            if (!mq.getLinie().equals((Object)this.modelSegment)) continue;
            aufsegment.add(mq);
        }
        if (aufsegment.size() > 0) {
            Collections.sort(aufsegment, new Comparator<MessQuerschnittAllgemein>(){

                @Override
                public int compare(MessQuerschnittAllgemein o1, MessQuerschnittAllgemein o2) {
                    return new Float(o1.getOffset()).compareTo(new Float(o2.getOffset()));
                }
            });
            MessQuerschnittAllgemein vor = null;
            for (MessQuerschnittAllgemein mq : aufsegment) {
                if (mq.getOffset() < (float)this.modelSegment.getStartOffset()) {
                    vor = mq;
                }
                if (foundmq == null || mq.getOffset() > foundmq.getOffset()) {
                    foundmq = mq;
                }
                if (foundmq == null || !(mq.getOffset() > (float)this.modelSegment.getStartOffset())) continue;
                break;
            }
            if (vor != null) {
                foundmq = vor;
            }
        }
        if (foundmq != null) {
            return new MessQuerschnitt(foundmq);
        }
        return null;
    }
}

