/*
 * Copyright 2006 by inovat, Dipl.-Ing. H. C. Kni
 * ALL RIGHTS RESERVED.
 *
 * THIS SOFTWARE IS  PROVIDED  "AS IS"  AND ANY EXPRESSED OR IMPLIED
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF  MERCHANTABILITY  AND  FITNESS  FOR  A PARTICULAR  PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL inovat OR ITS CONTRIBUTORS BE
 * LIABLE FOR ANY  DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY,
 * OR CONSEQUENTIAL DAMAGES  (INCL., BUT NOT LIMITED TO, PROCUREMENT
 * OF SUBSTITUTE GOODS OR SERVICES;  LOSS OF USE, DATA, OR  PROFITS;
 * OR BUSINESS INTERRUPTION)  HOWEVER  CAUSED  AND  ON ANY THEORY OF
 * LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,  OR TORT (INCL.
 * NEGLIGENCE OR OTHERWISE)  ARISING  IN  ANY  WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

package de.bsvrz.kex.isis.isis;

/**
 * Legt das Interface zu dem Ergebnis einer Baustellenprognose des BaustellenInformationsSystem (BIS) fest. &Uuml;ber eine
 * Klasse, die dieses Interface implementiert, k&ouml;nnen auf die Prognoseergebnisse der Baustellen des an die AK-VRZ
 * Software angebunden Baustelleninformationssystems zugegriffen werden.
 *
 * @author inovat, innovative systeme - verkehr - tunnel - technik
 * @author Dipl.-Ing. Hans Christian Kni (HCK)
 * @version $Revision: 143 $ / $Date: 2006-12-14 00:40:06 +0100 (Do, 14 Dez 2006) $ / ($Author: HCK $)
 */

public interface BaustellenPrognoseInterface {

	/**
	 * Liefert die Anfangszeitpunkte der prognostizierten Staus f&uuml;r die Baustelle (in ms seit dem 1.1.1970 UTC).
	 *
	 * @return Anfangszeitpunkte der prognostizierten Staus f&uuml;r die Baustelle (in ms seit dem 1.1.1970 UTC).
	 */
	public long[] getStauBeginn();

	/**
	 * Liefert die Zeitdauern der prognostizierten Staus (in ms).
	 *
	 * @return Zeitdauern der prognostizierten Staus (in ms).
	 */
	public long[] getStauDauern();

	/**
	 * Liefert die  Maximalen Staul&auml;ngen der prognostizierten Staus (in Metern).
	 *
	 * @return Maximalen Staul&auml;ngen der prognostizierten Staus (in Metern)
	 */
	public long[] getMaximaleStauLaengen();

	/**
	 * Liefert die Zeitpunkte der maximalen Staul&auml;ngen (in ms).
	 *
	 * @return Zeitpunkte der maximalen Staul&auml;ngen (in ms).
	 */
	public long[] getZeitpunkteDerMaximalenStauLaengen();

	/**
	 * Liefert die Maximalen Verlustzeiten der Staus.
	 *
	 * @return Maximalen Verlustzeiten der Staus (in ms).
	 */
	public long[] getMaximaleVerlustzeiten();

}
