/*
 * Copyright 2006 by inovat, Dipl.-Ing. H. C. Kni
 * ALL RIGHTS RESERVED.
 *
 * THIS SOFTWARE IS  PROVIDED  "AS IS"  AND ANY EXPRESSED OR IMPLIED
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF  MERCHANTABILITY  AND  FITNESS  FOR  A PARTICULAR  PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL inovat OR ITS CONTRIBUTORS BE
 * LIABLE FOR ANY  DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY,
 * OR CONSEQUENTIAL DAMAGES  (INCL., BUT NOT LIMITED TO, PROCUREMENT
 * OF SUBSTITUTE GOODS OR SERVICES;  LOSS OF USE, DATA, OR  PROFITS;
 * OR BUSINESS INTERRUPTION)  HOWEVER  CAUSED  AND  ON ANY THEORY OF
 * LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,  OR TORT (INCL.
 * NEGLIGENCE OR OTHERWISE)  ARISING  IN  ANY  WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

package de.bsvrz.kex.isis.isis;

/**
 * Repr&auml;sentiert Informationen zu einem (Baustellen-)Verantwortlichen.
 * 
 * @author inovat, innovative systeme - verkehr - tunnel - technik
 * @author Hans Christian Kni (HCK)
 * @version $Revision: 143 $ / $Date: 2006-12-14 00:40:06 +0100 (Do, 14 Dez
 *          2006) $ / ($Author: HCK $)
 */

public interface BaustellenVerantwortlicherInterface {

	// ------------------------------------------------------------------------
	// GETTER / SETTER METHODEN
	// ------------------------------------------------------------------------

	/**
	 * Gibt den Namen der verantwortlichen Firma zur&uuml;ck.
	 * 
	 * @return Name der verantwortlichen Firma.
	 */
	String getFirma();

	/**
	 * Gibt den Namen des Baustellenverantwortlichen zur&uuml;ck.
	 * 
	 * @return Namen des Baustellenverantwortlichen.
	 */
	String getNameBaustellenVerantwortlicher();

	/**
	 * Gibt die Telefonnummer des Baustellenverantwortlichen zur&uuml;ck.
	 * 
	 * @return Telefonnummer des Baustellenverantwortlichen.
	 */
	String getTelefonBaustellenVerantwortlicher();

	/**
	 * Gibt die Telefonnummer der verantwortlichen Firma zur&uuml;ck.
	 * 
	 * @return Telefonnummer der verantwortlichen Firma.
	 */
	String getTelefonFirma();

	/**
	 * Gibt den Handynummer des Baustellenverantwortlichen zur&uuml;ck.
	 * 
	 * @return Handynummer des Baustellenverantwortlichen.
	 */
	String getTelefonMobilBaustellenVerantwortlicher();

}
