/*
 * Copyright 2006 by inovat, Dipl.-Ing. H. C. Kni
 * ALL RIGHTS RESERVED.
 *
 * THIS SOFTWARE IS  PROVIDED  "AS IS"  AND ANY EXPRESSED OR IMPLIED
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF  MERCHANTABILITY  AND  FITNESS  FOR  A PARTICULAR  PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL inovat OR ITS CONTRIBUTORS BE
 * LIABLE FOR ANY  DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY,
 * OR CONSEQUENTIAL DAMAGES  (INCL., BUT NOT LIMITED TO, PROCUREMENT
 * OF SUBSTITUTE GOODS OR SERVICES;  LOSS OF USE, DATA, OR  PROFITS;
 * OR BUSINESS INTERRUPTION)  HOWEVER  CAUSED  AND  ON ANY THEORY OF
 * LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,  OR TORT (INCL.
 * NEGLIGENCE OR OTHERWISE)  ARISING  IN  ANY  WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

package de.bsvrz.kex.isis.isis;

/**
 * Interface, dass eine Klasse implementieren muss, die das
 * {@link de.bsvrz.kex.isis.isis.BisInterface} verwendet und &uuml;ber den
 * aktuellen Kommunikationsstatus des Interface zum Datenverteilersystem
 * informiert werden m&ouml;chte.
 * 
 * @author inovat, innovative systeme - verkehr - tunnel - technik
 * @author Dipl.-Ing. Hans Christian Kni (HCK)
 * @version $Revision: 132 $ / $Date: 2006-11-10 21:13:41 +0100 (Fr, 10 Nov
 *          2006) $ / ($Author: HCK $)
 */

public interface BisKommunikationsStatusListener {
	// ------------------------------------------------------------------------
	// SONSTIGE METHODEN
	// ------------------------------------------------------------------------

	/**
	 * Methode, die vom ({@link de.bsvrz.kex.isis.isis.BisInterface})
	 * aufgerufen wird, um &uuml;ber den aktuellen Status der Kommunikations
	 * zwischen dem BisInterface und dem DaV-System zu informieren.
	 * 
	 * @param bisKommunikationsStatus
	 *            Aktueller Kommunikationsstatus des BIS-Interfaces.
	 */
	void setKommunikationsStatus(
			BisInterface.BisKommunikationsStatus bisKommunikationsStatus);
}
