/*
 * Copyright 2006 by inovat, Dipl.-Ing. H. C. Kni
 * ALL RIGHTS RESERVED.
 *
 * THIS SOFTWARE IS  PROVIDED  "AS IS"  AND ANY EXPRESSED OR IMPLIED
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF  MERCHANTABILITY  AND  FITNESS  FOR  A PARTICULAR  PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL inovat OR ITS CONTRIBUTORS BE
 * LIABLE FOR ANY  DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY,
 * OR CONSEQUENTIAL DAMAGES  (INCL., BUT NOT LIMITED TO, PROCUREMENT
 * OF SUBSTITUTE GOODS OR SERVICES;  LOSS OF USE, DATA, OR  PROFITS;
 * OR BUSINESS INTERRUPTION)  HOWEVER  CAUSED  AND  ON ANY THEORY OF
 * LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,  OR TORT (INCL.
 * NEGLIGENCE OR OTHERWISE)  ARISING  IN  ANY  WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

package de.bsvrz.kex.isis.isis;

/**
 * Legt das Interface zu einem Ganglinienobjekt des BaustellenInformationsSystem
 * (BIS) fest. &Uuml;ber eine Klasse, die dieses Interface implementiert, kann
 * auf die Ganglinien des an die AK-VRZ Software angebunden
 * Baustelleninformationssystems zugegriffen werden.
 * 
 * @author inovat, innovative systeme - verkehr - tunnel - technik
 * @author Dipl.-Ing. Hans Christian Kni (HCK)
 * @version $Revision: 143 $ / $Date: 2006-12-14 00:40:06 +0100 (Do, 14 Dez
 *          2006) $ / ($Author: HCK $)
 */

public interface GanglinienInterface {
	// ------------------------------------------------------------------------
	// SONSTIGE METHODEN
	// ------------------------------------------------------------------------

	/**
	 * Liefert das Datum, f&uuml;r das diese Gangliniendaten g&uuml;ltig sind.
	 * 
	 * @return Datum (in ms seit dem 1.1.1970 UTC), f&uuml;r das diese
	 *         Gangliniendaten g&uuml;ltig sind. Angeben wird jeweils der
	 *         Anfangszeitpunkt des Tages, f&uuml;r den 20.11.2006 also die
	 *         Angabe "27.11.2006 00:00:00,000" in ms seit dem 1.1.1970 UTC.
	 */
	long getDatum();

	/**
	 * Liefert genau 24 QKfz-Werte (je Stunde des Tages ein Wert).
	 * 
	 * @return 24 QKfz-Werte. Je Stunde des Tages wird ein Wert geliefert.
	 * 
	 * <pre>
	 *  (QKfz[0] = Wert von 0:00 bis 00:59)
	 *  (QKfz[1] = Wert von 1:00 bis 01:59)
	 *  ...
	 *  (QKfz[23] = Wert von 23:00 bis 23:59)
	 * </pre>
	 * 
	 * Kann ein Wert nicht ermittelt werden, so wird -1 zur&uuml;ckgegeben.
	 */
	int[] getQKfz();

	/**
	 * Liefert genau 24 QLkw-Werte (je Stunde des Tages ein Wert).
	 * 
	 * @return 24 QLkw-Werte. Je Stunde des Tages wird ein Wert geliefert.
	 * 
	 * <pre>
	 *  (QLkw[0] = Wert von 0:00 bis 00:59)
	 *  (QLkw[1] = Wert von 1:00 bis 01:59)
	 *  ...
	 *  (QLkw[23] = Wert von 23:00 bis 23:59)
	 * </pre>
	 */
	int[] getQLkw();

	/**
	 * Liefert genau 24 QPkw-Werte (je Stunde des Tages ein Wert).
	 * 
	 * @return 24 QPkw-Werte. Je Stunde des Tages wird ein Wert geliefert.
	 * 
	 * <pre>
	 *  (QPkw[0] = Wert von 0:00 bis 00:59)
	 *  (QPkw[1] = Wert von 1:00 bis 01:59)
	 *  ...
	 *  (QPkw[23] = Wert von 23:00 bis 23:59)
	 * </pre>
	 * 
	 * Kann ein Wert nicht ermittelt werden, so wird -1 zur&uuml;ckgegeben.
	 */
	int[] getQPkw();

	/**
	 * Liefert genau 24 QKfz-Werte (je Stunde des Tages ein Wert).
	 * 
	 * @return 24 QKfz-Werte. Je Stunde des Tages wird ein Wert geliefert.
	 * 
	 * <pre>
	 *  (VKfz[0] = Wert von 0:00 bis 00:59)
	 *  (VKfz[1] = Wert von 1:00 bis 01:59)
	 *   ...
	 *  (VKfz[23] = Wert von 23:00 bis 23:59)
	 * </pre>
	 * 
	 * Kann ein Wert nicht ermittelt werden, so wird -1 zur&uuml;ckgegeben.
	 */
	int[] getVKfz();

	/**
	 * Liefert genau 24 VLkw-Werte (je Stunde des Tages ein Wert).
	 * 
	 * @return 24 VLkw-Werte. Je Stunde des Tages wird ein Wert geliefert.
	 * 
	 * <pre>
	 *  (VLkw[0] = Wert von 0:00 bis 00:59)
	 *  (VLkw[1] = Wert von 1:00 bis 01:59)
	 *   ...
	 *  (VLkw[23] = Wert von 23:00 bis 23:59)
	 * </pre>
	 * 
	 * Kann ein Wert nicht ermittelt werden, so wird -1 zur&uuml;ckgegeben.
	 */
	int[] getVLkw();

	/**
	 * Liefert genau 24 VPkw-Werte (je Stunde des Tages ein Wert).
	 * 
	 * @return 24 VPkw-Werte. Je Stunde des Tages wird ein Wert geliefert.
	 * 
	 * <pre>
	 *  (VPkw[0] = Wert von 0:00 bis 00:59)
	 *  (VPkw[1] = Wert von 1:00 bis 01:59)
	 *  ...
	 *  (VPkw[23] = Wert von 23:00 bis 23:59)
	 * </pre>
	 * 
	 * Kann ein Wert nicht ermittelt werden, so wird -1 zur&uuml;ckgegeben.
	 */
	int[] getVPkw();
}
