/*
 * Copyright 2006 by inovat, Dipl.-Ing. H. C. Kni
 * ALL RIGHTS RESERVED.
 *
 * THIS SOFTWARE IS  PROVIDED  "AS IS"  AND ANY EXPRESSED OR IMPLIED
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF  MERCHANTABILITY  AND  FITNESS  FOR  A PARTICULAR  PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL inovat OR ITS CONTRIBUTORS BE
 * LIABLE FOR ANY  DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY,
 * OR CONSEQUENTIAL DAMAGES  (INCL., BUT NOT LIMITED TO, PROCUREMENT
 * OF SUBSTITUTE GOODS OR SERVICES;  LOSS OF USE, DATA, OR  PROFITS;
 * OR BUSINESS INTERRUPTION)  HOWEVER  CAUSED  AND  ON ANY THEORY OF
 * LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,  OR TORT (INCL.
 * NEGLIGENCE OR OTHERWISE)  ARISING  IN  ANY  WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

package de.bsvrz.kex.isis.isis;

/**
 * Legt das Interface zu einem Messqueschnitt des BaustellenInformationsSystem (BIS) fest. &Uuml;ber eine Klasse, die dieses
 * Interface implementiert, kann auf die Messquerschnitte des an die AK-VRZ Software angebunden
 * Baustelleninformationssystems zugegriffen werden.
 *
 * @author inovat, innovative systeme - verkehr - tunnel - technik
 * @author Dipl.-Ing. Hans Christian Kni (HCK)
 * @version $Revision: 129 $ / $Date: 2006-12-15 23:24:31 +0100 (Fr, 15 Dez 2006) $ / ($Author: HCK $)
 */

public interface MessQuerschnittInterface {
	// ------------------------------------------------------------------------
	// SONSTIGE METHODEN
	// ------------------------------------------------------------------------

	/**
	 * Liefert die Ganglinien f&uuml;r eine Liste von Querschnittsobjekten f&uuml;r einen Zeitbereich.
	 *
	 * @param vonZeitpunkt Startzeitpunkt, ab dem die Ganglinien ermittelt werden sollen. (in ms seit dem 1.1.1970 UTC)
	 * @param bisZeitpunkt Endzeitpunkt, bis zu dem die Ganglinien ermittelt werden sollen. (in ms seit dem 1.1.1970 UTC)
	 *
	 * @return Ganglinien als Array von {@link de.bsvrz.kex.isis.isis.GanglinienInterface}.  Es wird jeweils der
	 *         gesamte Tag zur&uuml;ckgeliefert, auf den der Anfangs-bzw. Endzweitpunkt f&auml;llt. Fallen diese nicht auf den
	 *         gleichen Tag, werden entsprechend mehrere Ganglinien zur&uuml;ckgegeben. K&ouml;nnen f&uuml;r den Anfragezeitraum keine
	 *         Ganglinien ermittelt werden, wird ein leeres Array zur&uuml;ckgegeben.
	 * @throws BisInterfaceException 
	 */
	public GanglinienInterface[] getGanglinien(long vonZeitpunkt, long bisZeitpunkt) throws BisInterfaceException;

	/**
	 * Liefert den Namen des Messquerschnitts.
	 *
	 * @return Name des Messquerschnitts.
	 */
	public String getName();

	/**
	 * Liefert die Pid des Messquerschnitts (weltweit eindeutige PermanenteID).
	 *
	 * @return Pid des Messquerschnitts.
	 */
	public String getPid();
}
