/*
 * Copyright 2006 by inovat, Dipl.-Ing. H. C. Kni
 * ALL RIGHTS RESERVED.
 *
 * THIS SOFTWARE IS  PROVIDED  "AS IS"  AND ANY EXPRESSED OR IMPLIED
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF  MERCHANTABILITY  AND  FITNESS  FOR  A PARTICULAR  PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL inovat OR ITS CONTRIBUTORS BE
 * LIABLE FOR ANY  DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY,
 * OR CONSEQUENTIAL DAMAGES  (INCL., BUT NOT LIMITED TO, PROCUREMENT
 * OF SUBSTITUTE GOODS OR SERVICES;  LOSS OF USE, DATA, OR  PROFITS;
 * OR BUSINESS INTERRUPTION)  HOWEVER  CAUSED  AND  ON ANY THEORY OF
 * LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,  OR TORT (INCL.
 * NEGLIGENCE OR OTHERWISE)  ARISING  IN  ANY  WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

package de.bsvrz.kex.isis.isis;

import java.util.List;

/**
 * Repr&auml;sentiert eine Ortsreferenz nach dem ASB-Stationierungssystem. <p/>
 * Bei dem das ASB-Stationierungssystem wird die Ortsrefererenz &uuml;ber
 * Anfangs- und Endpunkt (Netzknoten bzw. Nullpunkt) sowie der Stationierung im
 * Wertebereich von 0 bis zugewiesene L&auml;nge sowie der Richtung festgelegt.
 * <p/> Kurzbeschreibung des ASB-Stationierungssystems: <p/> Die Kreuzungen
 * (Netzknoten) des klassifizierten Stra&szlig;ennetzes erhalten innerhalb eines
 * Kartenblattes einer Topographischen Karte eine eindeutige Nummer. Die
 * Beschreibung eines Stra&szlig;enabschnitts ergibt sich nun aus der Nennung
 * von Anfangsknoten und Endknoten. Diesem Stra&szlig;enabschnitt wird die reale
 * L&auml;nge (Keine Berechnung aufgrund von Koordinaten!) zugewiesen. Innerhalb
 * eines Netzknotens k&ouml;nnen &Auml;ste definiert werden. Diese &Auml;ste
 * starten und Enden an so genannten Nullpunkten, die im Bezug zum Netzknoten
 * eindeutig indiziert sind. Den &Auml;sten wird ebenfalls die reale L&auml;nge
 * zugewiesen. Die Lagebeschreibung von Punkte entlang eines Abschnitts oder
 * eines Astes kann man nun eindeutig durch den Anfangs- und Endpunkt
 * (Netzknoten bzw. Nullpunkt) sowie der Stationierung im Wertebereich von 0 bis
 * zugewiesene L&auml;nge sowie der Richtung (ergibt sich aus der Reihenfolge
 * der Netzknoten) erfolgen. Bei dem &Uuml;bergang auf die Darstellung von
 * Verkehrsbeziehungen werden die Nullpunkte zu Verbindungspunkte. Zwischen den
 * Verbindungspunkten sind Stra&szlig;enelemente definiert. Dabei besitzen die
 * Stra&szlig;enelemente nach Definition ASB eine Referenz auf das oben
 * beschriebene ASB Stationierungssystem. Durch diese Referenzierung der
 * Stra&szlig;enelemente auf die Stra&szlig;enabschnitte lassen sich alle
 * Informationen von Abschnitten und &Auml;sten &uuml;ber das
 * Stationierungssystem auf die Stra&szlig;enelemente &uuml;bertragen.
 * 
 * @author inovat, innovative systeme - verkehr - tunnel - technik
 * @author Hans Christian Kni (HCK)
 * @version $Revision: 143 $ / $Date: 2006-12-14 00:40:06 +0100 (Do, 14 Dez
 *          2006) $ / ($Author: HCK $)
 */

public interface OrtsReferenzAsbStationierungInterface {
	// ------------------------------------------------------------------------
	// SONSTIGE METHODEN
	// ------------------------------------------------------------------------

	/**
	 * Rechnet Ortsreferenzen vom ASB-Stationierungssystem in Angaben mit
	 * Stra&szlig;enSegment und den Offset vom Anfang des Stra&szlig;enSegments
	 * um. Da potentiell mehrere Stra&szlig;en &uuml;ber einen Abschnitt
	 * verlaufen k&ouml;nnen, wird eine Liste aller gefundenen Referenzen
	 * gebildet.
	 * 
	 * @return Liste von Ortsreferenzen, bei denen die Ortsangabe &uuml;ber ein
	 *         Stra&szlig;enSegment und den Offset vom Anfang des
	 *         Stra&szlig;enSegments dargestellt wird.
	 * 
	 * @throws BisInterfaceException
	 *             wenn keine Abbildung m&ouml;glich ist.
	 */
	public List<OrtsReferenzStrassenSegmentUndOffsetInterface> ermittleOrtsReferenzStrassenSegmentUndOffset()
			throws BisInterfaceException;

	/**
	 * Rechnet Ortsreferenzen vom ASB-Stationierungssystem in Angaben &uuml;ber
	 * eine Stra&szlig;e und den Betriebskilometers um.
	 * 
	 * @return Ortsreferenz, bei dem die Ortsangabe &uuml;ber eine Stra&szlig;e
	 *         und den Betriebskilometer dargestellt wird.
	 * 
	 * @throws BisInterfaceException
	 *             wenn keine Abbildung m&ouml;glich ist
	 */
	public List<OrtsReferenzStrasseUndBetriebsKilometerInterface> ermittleOrtsReferenzStrasseUndBetriebsKilometer()
			throws BisInterfaceException;

	/**
	 * Gibt den Anfangsknoten der ASB Stationierung zur&uuml;ck.
	 * 
	 * @return Anfangsknoten der ASB Stationierung. Anfangsknoten mit
	 *         eindeutiger Kennung (Anfangsnullpunkt) des Teilabschnittes oder
	 *         Astes. Die Nullpunktbezeichung hat die Form TTTTnnnB, wobei TTTT
	 *         die vierstellige TK25-Blattnummer und nnn die dreistellige
	 *         laufende Nummer ist, die zusammen die bundesweit eindeutige
	 *         Netzknotennummer darstellen. Durch die Kennung B (ein Zeichen)
	 *         wird zus&auml;tzlich der Nullpunkt des Abschnitts oder Astes
	 *         eindeutig festgelegt. Eine nicht vorhandene Kennung wird als
	 *         o(hne) eingetragen.
	 */
	public String getAnfangsKnoten();

	/**
	 * Gibt die Stationierungsrichtung f&uuml;r den ASB Abschnitt zur&uuml;ck.
	 * 
	 * @return Stationierungsrichtung f&uuml;r den ASB Abschnitt.
	 */
	public BisInterface.ASBStationierungsRichtung getAsbStationierungsRichtung();

	/**
	 * Gibt den Endknoten der ASB Stationierung zur&uuml;ck.
	 * 
	 * @return Endknoten der ASB Stationierung. Endknoten mit eindeutiger
	 *         Kennung (Endnullpunkt) des Teilabschnittes oder Astes. Die
	 *         Nullpunktbezeichung hat die Form TTTTnnnB, wobei TTTT die
	 *         vierstellige TK25-Blattnummer und nnn die dreistellige laufende
	 *         Nummer ist, die zusammen die bundesweit eindeutige
	 *         Netzknotennummer darstellen. Durch die Kennung B (ein Zeichen)
	 *         wird zus&auml;tzlich der Nullpunkt des Abschnitts oder Astes
	 *         eindeutig festgelegt. Eine nicht vorhandene Kennung wird als
	 *         o(hne) eingetragen.
	 */
	public String getEndKnoten();

	/**
	 * Gibt die Stationierung (in Metern) auf dem ASB Abschnitt zur&uuml;ck.
	 * 
	 * @return Stationierung (in Metern) auf dem ASB Abschnitt.
	 */
	public long getStationierung();
}
