/*
 * Copyright 2006 by inovat, Dipl.-Ing. H. C. Kni
 * ALL RIGHTS RESERVED.
 *
 * THIS SOFTWARE IS  PROVIDED  "AS IS"  AND ANY EXPRESSED OR IMPLIED
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF  MERCHANTABILITY  AND  FITNESS  FOR  A PARTICULAR  PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL inovat OR ITS CONTRIBUTORS BE
 * LIABLE FOR ANY  DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY,
 * OR CONSEQUENTIAL DAMAGES  (INCL., BUT NOT LIMITED TO, PROCUREMENT
 * OF SUBSTITUTE GOODS OR SERVICES;  LOSS OF USE, DATA, OR  PROFITS;
 * OR BUSINESS INTERRUPTION)  HOWEVER  CAUSED  AND  ON ANY THEORY OF
 * LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,  OR TORT (INCL.
 * NEGLIGENCE OR OTHERWISE)  ARISING  IN  ANY  WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

package de.bsvrz.kex.isis.isis;

/**
 * Repr&auml;sentiert eine Ortsrefererenz &uuml;ber die Angabe einer
 * Stra&szlig;e und des Betriebskilometers.
 * 
 * @author inovat, innovative systeme - verkehr - tunnel - technik
 * @author Hans Christian Kni (HCK)
 * @version $Revision: 143 $ / $Date: 2006-12-14 00:40:06 +0100 (Do, 14 Dez
 *          2006) $ / ($Author: HCK $)
 */

public interface OrtsReferenzStrasseUndBetriebsKilometerInterface {
	// ------------------------------------------------------------------------
	// SONSTIGE METHODEN
	// ------------------------------------------------------------------------

	/**
	 * Rechnet Ortsreferenzen mit Stra&szlig;e und Betriebskilometer in
	 * Ortsangabe &uuml;ber das ASB-Stationierungssystem um (Anfangs- und
	 * Endpunkt (Netzknoten bzw. Nullpunkt), Stationierung im Wertebereich von 0
	 * bis zugewiesene L&auml;nge sowie Angabe der Richtung).
	 * 
	 * @return Ortsreferenz nach dem ASB-Stationierungssystem.
	 * 
	 * @throws BisInterfaceException
	 *             wenn keine Abbildung m&ouml;glich ist.
	 */
	public OrtsReferenzAsbStationierungInterface ermittleOrtsReferenzAsbStationierung()
			throws BisInterfaceException;

	/**
	 * Rechnet Ortsreferenzen mit Stra&szlig;e und Betriebskilometer in Angaben
	 * mit Stra&szlig;enSegment und den Offset vom Anfang des
	 * Stra&szlig;enSegments um.
	 * 
	 * @return Ortsreferenz, bei dem die Ortsangabe &uuml;ber ein
	 *         Stra&szlig;enSegment und den Offset vom Anfang des
	 *         Stra&szlig;enSegments dargestellt wird.
	 * 
	 * @throws BisInterfaceException
	 *             wenn keine Abbildung m&ouml;glich ist.
	 */
	public OrtsReferenzStrassenSegmentUndOffsetInterface ermittleOrtsReferenzStrassenSegmentUndOffset()
			throws BisInterfaceException;

	/**
	 * Gibt den Betriebskilometer auf der Stra&szlig;e zur&uuml;ck.
	 * 
	 * @return Betriebskilometer auf der Stra&szlig;e in Metern.
	 */
	public long getBetriebsKilometer();

	/**
	 * Gibt die Blocknummer des Betriebskilometers auf der Stra&szlig;e
	 * zur&uuml;ck.
	 * 
	 * @return Blocknummer des Betriebskilometers auf der Stra&szlig;e.
	 */
	public int getBlockNummer();

	/**
	 * Gibt die Richtung, in der die Stra&szlig;e durchlaufen wird, zur&uuml;ck.
	 * 
	 * @return Richtung auf dem Stra&szlig;enSegment.
	 */
	public BisInterface.FahrtRichtung getFahrtRichtung();

	/**
	 * Gibt die referenzierte Stra&szlig;e zur&uuml;ck.
	 * 
	 * @return Referenzierte Stra&szlig;e.
	 */
	public StrasseInterface getStrasse();
}
