/*
 * Copyright 2006 by inovat, Dipl.-Ing. H. C. Kni
 * ALL RIGHTS RESERVED.
 *
 * THIS SOFTWARE IS  PROVIDED  "AS IS"  AND ANY EXPRESSED OR IMPLIED
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF  MERCHANTABILITY  AND  FITNESS  FOR  A PARTICULAR  PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL inovat OR ITS CONTRIBUTORS BE
 * LIABLE FOR ANY  DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY,
 * OR CONSEQUENTIAL DAMAGES  (INCL., BUT NOT LIMITED TO, PROCUREMENT
 * OF SUBSTITUTE GOODS OR SERVICES;  LOSS OF USE, DATA, OR  PROFITS;
 * OR BUSINESS INTERRUPTION)  HOWEVER  CAUSED  AND  ON ANY THEORY OF
 * LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,  OR TORT (INCL.
 * NEGLIGENCE OR OTHERWISE)  ARISING  IN  ANY  WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

package de.bsvrz.kex.isis.isis;

/**
 * Repr&auml;sentiert eine Ortsrefererenz &uuml;ber die Angabe eines
 * Stra&szlig;enSegments und dem Offset vom Anfang des Stra&szlig;enSegments.
 * 
 * @author inovat, innovative systeme - verkehr - tunnel - technik
 * @author Hans Christian Kni (HCK)
 * @version $Revision: 143 $ / $Date: 2006-12-14 00:40:06 +0100 (Do, 14 Dez
 *          2006) $ / ($Author: HCK $)
 */

public interface OrtsReferenzStrassenSegmentUndOffsetInterface {
	// ------------------------------------------------------------------------
	// SONSTIGE METHODEN
	// ------------------------------------------------------------------------

	/**
	 * Rechnet Ortsreferenzen mit Stra&szlig;enSegment und den Offset in
	 * Ortsangabe &uuml;ber das ASB-Stationierungssystem um (Anfangs- und
	 * Endpunkt (Netzknoten bzw. Nullpunkt), Stationierung im Wertebereich von 0
	 * bis zugewiesene L&auml;nge sowie Angabe der Richtung).
	 * 
	 * @return Ortsreferenz nach dem ASB-Stationierungssystem.
	 * 
	 * @throws BisInterfaceException
	 *             wenn keine Abbildung m&ouml;glich ist.
	 */
	OrtsReferenzAsbStationierungInterface ermittleOrtsReferenzAsbStationierung()
			throws BisInterfaceException;

	/**
	 * Rechnet Ortsreferenzen mit Stra&szlig;enSegment und den Offset in Angaben
	 * &uuml;ber eine Stra&szlig;e und den Betriebskilometers um.
	 * 
	 * @return Ortsreferenz, bei dem die Ortsangabe &uuml;ber eine Stra&szlig;e
	 *         und den Betriebskilometer dargestellt wird.
	 * 
	 * @throws BisInterfaceException
	 *             wenn keine Abbildung m&ouml;glich ist.
	 */

	OrtsReferenzStrasseUndBetriebsKilometerInterface ermittleOrtsReferenzStrasseUndBetriebsKilometer()
			throws BisInterfaceException;

	/**
	 * Gibt die L&auml;ngsneigung f&uuml;r das Stra&szlig;ensegment am
	 * betrachteten Offset zur&uuml;ck.
	 * 
	 * @return L&auml;ngsneigung f&uuml;r das Stra&szlig;ensegment am
	 *         betrachteten Offset.
	 * 
	 * @throws BisInterfaceException
	 *             wenn keine Abbildung m&ouml;glich ist.
	 */
	Integer getLaengsNeigung() throws BisInterfaceException;

	/**
	 * Gibt den Offset auf dem Stra&szlig;enSegment zur&uuml;ck.
	 * 
	 * @return Offset auf dem Stra&szlig;enSegment in Metern.
	 */
	long getStartOffset();

	/**
	 * Gibt das referenzierte Stra&szlig;enSegment zur&uuml;ck.
	 * 
	 * @return Referenziertes Stra&szlig;enSegment.
	 */
	StrassenSegmentInterface getStrassenSegment();

	/**
	 * Liefert den {@link de.bsvrz.kex.isis.isis.MessQuerschnittInterface}, der
	 * den Zufluss an der Stelle der angegebenen Ortsreferenz liefert.
	 * 
	 * @return MessQuerschnitt, der den Zufluss an der Stelle der angegebenen
	 *         Ortsreferenz liefert oder <code>null</code>, wenn keine
	 *         {@link de.bsvrz.kex.isis.isis.MessQuerschnittInterface}
	 *         ermittelbar ist. Dabei wird folgender Algorithmus angewandt.
	 *         Zuerst wird der MessQuerschnitt vor der angegebene Ortsreferenz
	 *         ermittelt, der sich im SELBEN Stra&szlig;enSegment wie die
	 *         angegebene Ortsreferenz befindet. Existiert dieser MQ nicht, so
	 *         wird der erste MQ innerhalb des angegebenen Bereichs ermittelt
	 *         und zur&uuml;ckgegeben. Existiert auch dieser nicht, so wird der
	 *         erste MQ nach dem Bereich ermittelt, der sich im SELBEN
	 *         Stra&szlig;enSegment wie das Ende des Bereichs befindet.
	 * 
	 * @throws BisInterfaceException
	 *             wenn kein MQ gefunden wird.
	 */
	MessQuerschnittInterface getZuflussMessQuerschnitt()
			throws BisInterfaceException;
}
