/*
 * Copyright 2006 by inovat, Dipl.-Ing. H. C. Kni
 * ALL RIGHTS RESERVED.
 *
 * THIS SOFTWARE IS  PROVIDED  "AS IS"  AND ANY EXPRESSED OR IMPLIED
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF  MERCHANTABILITY  AND  FITNESS  FOR  A PARTICULAR  PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL inovat OR ITS CONTRIBUTORS BE
 * LIABLE FOR ANY  DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY,
 * OR CONSEQUENTIAL DAMAGES  (INCL., BUT NOT LIMITED TO, PROCUREMENT
 * OF SUBSTITUTE GOODS OR SERVICES;  LOSS OF USE, DATA, OR  PROFITS;
 * OR BUSINESS INTERRUPTION)  HOWEVER  CAUSED  AND  ON ANY THEORY OF
 * LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,  OR TORT (INCL.
 * NEGLIGENCE OR OTHERWISE)  ARISING  IN  ANY  WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

package de.bsvrz.kex.isis.isis;

/**
 * Legt das Interface zu einer Stra&szlig;e des BaustellenInformationsSystem (BIS) fest. &Uuml;ber eine Klasse, die dieses
 * Interface implementiert, k&ouml;nnen auf die Stra&szlig;en des an die AK-VRZ Software angebunden Baustelleninformationssystems
 * zugegriffen werden.
 *
 * @author inovat, innovative systeme - verkehr - tunnel - technik
 * @author Dipl.-Ing. Hans Christian Kni (HCK)
 * @version $Revision: 143 $ / $Date: 2006-12-14 00:40:06 +0100 (Do, 14 Dez 2006) $ / ($Author: HCK $)
 */

public interface StrasseInterface {
	// ------------------------------------------------------------------------
	// SONSTIGE METHODEN
	// ------------------------------------------------------------------------

	/**
	 * Liefert den Namen der Stra&szlig;e.
	 *
	 * @return Name der Stra&szlig;e.
	 */
	public String getName();

	/**
	 * Liefert die Pid der Stra&szlig;e (weltweit eindeutige PermanenteID).
	 *
	 * @return Pid der Stra&szlig;e.
	 */
	public String getPid();

	/**
	 * Liefert die Stra&szlig;ennummer.
	 *
	 * @return Stra&szlig;ennummer der Stra&szlig;e. Beispiel: Bei der L128a also die 128.
	 */
	public int getStrassenNummer();

	/**
	 * Liefert den Stra&szlig;entyp dieser Stra&szlig;e.
	 *
	 * @return Stra&szlig;entyp dieser Stra&szlig;e. Folgende Werte k&ouml;nnen geliefert werden.
	 *         <pre>
	 *                 SonstigeStra&szlig;e       0
	 *                 Autobahn             1
	 *                 Bundesstra&szlig;e         2
	 *                 Landesstra&szlig;e         3
	 *                 Kreisstra&szlig;e          4
	 *                 Stadtstra&szlig;e          5
	 *                 Hauptverkehrsstra&szlig;e  6
	 *                 Sammelstra&szlig;e         7
	 *                 Anliegerstra&szlig;e       8
	 *                 </pre>
	 *         Beispiel: F&uuml;r die L128a liefert die Methode die 3.
	 */
	public int getStrassenTyp();

	/**
	 * Liefert den Zusatz zur Stra&szlig;ennummer.
	 *
	 * @return Zusatz zur Stra&szlig;ennummer der Stra&szlig;e. Beispiel: Bei der L128a also "a".
	 */
	public String getZusatz();
}
