/*
 * Segment 2 (KEx),  SWE 2.BW-ISIS
 * Copyright (C) 2007 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weienfelser Strae 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.kex.isis.isis.impl;

import de.bsvrz.dav.daf.main.config.ConfigurationChangeException;
import de.bsvrz.kex.isis.isis.BisInterface.BaustellenZustand;
import de.bsvrz.sys.funclib.bitctrl.modell.kalender.objekte.Ereignis;

/**
 * Repr&auml;sentiert ein Baustellenereignis.
 * 
 * @author BitCtrl Systems GmbH, Gieseler
 * @version $Id: BaustellenEreignis.java 7382 2008-03-12 16:21:41Z gieseler $
 * 
 */

public class BaustellenEreignis {

	/** der Baustellenzustand, zu dem dieses Ereignis angelegt wurde. */
	BaustellenZustand zustand;

	/** Ereignisobjekt. */
	Ereignis ereignis;

	/**
	 * Erzeugt ein Baustellenereignis.
	 * 
	 * @param zustand
	 *            Baustellenzustand, zu dem dieses Ereignis angelegt wurde
	 * @param ereignis
	 *            Ereignisobjekt
	 */
	public BaustellenEreignis(final BaustellenZustand zustand,
			final Ereignis ereignis) {
		super();
		this.zustand = zustand;
		this.ereignis = ereignis;
	}

	/**
	 * Gibt den zum Ereignis geh&ouml;renden Baustellenzustand zur&uuml;ck.
	 * 
	 * @return Baustellenzustand zum Ereignis
	 */
	protected BaustellenZustand getZustand() {
		return zustand;
	}

	/**
	 * L&ouml;scht das zugeh&ouml;rige Ereignisobjekt im DaV.
	 * 
	 * @throws ConfigurationChangeException
	 *             bei Ausnahmen
	 */
	public void loeschen() throws ConfigurationChangeException {
		ereignis.entfernen();
	}
}
