/*
 * Segment 2 (KEx),  SWE 2.BW-ISIS
 * Copyright (C) 2007 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weienfelser Strae 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.kex.isis.isis.impl;

import de.bsvrz.kex.isis.isis.BaustellenPrognoseInterface;
import de.bsvrz.sys.funclib.bitctrl.modell.verkehr.onlinedaten.OdBaustellenSimulation.Daten;

/**
 * Implementation des BaustellenPrognoseInterface.
 * 
 * @author BitCtrl Systems GmbH, Gieseler
 * @version $Id: BaustellenPrognose.java 7485 2008-03-17 14:49:20Z gieseler $
 * 
 */

public class BaustellenPrognose implements BaustellenPrognoseInterface {

	/**
	 * Die Daten der Baustellenprognose.
	 */
	private final Daten simudaten;

	/**
	 * Konstruktor.
	 * 
	 * @param daten
	 *            Prognosedaten
	 */
	public BaustellenPrognose(Daten daten) {
		simudaten = daten;
	}

	/**
	 * {@inheritDoc}
	 * 
	 * @see de.bsvrz.kex.isis.isis.BaustellenPrognoseInterface#getMaximaleStauLaengen()
	 */
	public long[] getMaximaleStauLaengen() {
		long[] laengen = new long[simudaten.getStaus().size()];

		for (int i = 0; i < simudaten.getStaus().size(); i++) {
			laengen[i] = simudaten.getStau(i).getMaxLaenge();
		}

		return laengen;
	}

	/**
	 * {@inheritDoc}
	 * 
	 * @see de.bsvrz.kex.isis.isis.BaustellenPrognoseInterface#getMaximaleVerlustzeiten()
	 */
	public long[] getMaximaleVerlustzeiten() {
		long[] vzeiten = new long[simudaten.getStaus().size()];

		for (int i = 0; i < simudaten.getStaus().size(); i++) {
			vzeiten[i] = simudaten.getStau(i).getVerlustZeit();
		}

		return vzeiten;
	}

	/**
	 * {@inheritDoc}
	 * 
	 * @see de.bsvrz.kex.isis.isis.BaustellenPrognoseInterface#getStauBeginn()
	 */
	public long[] getStauBeginn() {
		long[] beginn = new long[simudaten.getStaus().size()];

		for (int i = 0; i < simudaten.getStaus().size(); i++) {
			beginn[i] = simudaten.getStau(i).getStartZeit();
		}

		return beginn;
	}

	/**
	 * {@inheritDoc}
	 * 
	 * @see de.bsvrz.kex.isis.isis.BaustellenPrognoseInterface#getStauDauern()
	 */
	public long[] getStauDauern() {
		long[] dauer = new long[simudaten.getStaus().size()];

		for (int i = 0; i < simudaten.getStaus().size(); i++) {
			dauer[i] = simudaten.getStau(i).getDauer();
		}

		return dauer;
	}

	/**
	 * {@inheritDoc}
	 * 
	 * @see de.bsvrz.kex.isis.isis.BaustellenPrognoseInterface#getZeitpunkteDerMaximalenStauLaengen()
	 */
	public long[] getZeitpunkteDerMaximalenStauLaengen() {
		long[] zeitmaxlen = new long[simudaten.getStaus().size()];

		for (int i = 0; i < simudaten.getStaus().size(); i++) {
			zeitmaxlen[i] = simudaten.getStau(i).getMaxLaengeZeit();
		}

		return zeitmaxlen;

	}

}
