/*
 * Segment 2 (KEx),  SWE 2.BW-ISIS
 * Copyright (C) 2007 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weienfelser Strae 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.kex.isis.isis.impl;

import de.bsvrz.kex.isis.isis.BaustellenVerantwortlicherInterface;

/**
 * Implementation des BaustellenVerantwortlicherInterface.
 * 
 * @author BitCtrl Systems GmbH, Gieseler
 * @version $Id: BaustellenVerantwortlicher.java 10546 2008-07-17 11:25:17Z gieseler $
 * 
 */
public class BaustellenVerantwortlicher implements
		BaustellenVerantwortlicherInterface {

	/** Name der verantwortlichen Firma. */
	String firma;

	/** Telefonnummer der verantwortlichen Firma. */
	String nameBaustellenVerantwortlicher;

	/** Name des Baustellenverantwortlichen. */
	String telefonBaustellenVerantwortlicher;

	/** Telefonnummer des Baustellenverantwortlichen. */
	String telefonFirma;

	/** Mobiltelefonnummer des Baustellenverantwortlichen. */
	String telefonMobilBaustellenVerantwortlicher;

	/**
	 * Erzeugt einen neuen Baustellenverantwortlichen.
	 * 
	 * @param firma
	 *            Name der verantwortlichen Firma.
	 * @param nameBaustellenVerantwortlicher
	 *            Telefonnummer der verantwortlichen Firma.
	 * @param telefonBaustellenVerantwortlicher
	 *            Name des Baustellenverantwortlichen.
	 * @param telefonFirma
	 *            Telefonnummer des Baustellenverantwortlichen.
	 * @param telefonMobilBaustellenVerantwortlicher
	 *            Mobiltelefonnummer des Baustellenverantwortlichen.
	 */
	public BaustellenVerantwortlicher(String firma,
			String nameBaustellenVerantwortlicher,
			String telefonBaustellenVerantwortlicher, String telefonFirma,
			String telefonMobilBaustellenVerantwortlicher) {
		if (firma == null) {
			throw new IllegalArgumentException(
					"Die Firma des Baustellenverantwortlichen darf nicht 'null' sein");
		}

		if (nameBaustellenVerantwortlicher == null) {
			throw new IllegalArgumentException(
					"Der Name des Baustellenverantwortlichen darf nicht 'null' sein");
		}

		if (telefonBaustellenVerantwortlicher == null) {
			throw new IllegalArgumentException(
					"Die Telefonnummer des Baustellenverantwortlichen darf nicht 'null' sein");
		}

		if (telefonFirma == null) {
			throw new IllegalArgumentException(
					"Die Telefonnummer-Firma des Baustellenverantwortlichen darf nicht 'null' sein");
		}

		if (telefonMobilBaustellenVerantwortlicher == null) {
			throw new IllegalArgumentException(
					"Die Telefonnummer-Mobil des Baustellenverantwortlichen darf nicht 'null' sein");
		}

		this.firma = firma;
		this.nameBaustellenVerantwortlicher = nameBaustellenVerantwortlicher;
		this.telefonBaustellenVerantwortlicher = telefonBaustellenVerantwortlicher;
		this.telefonFirma = telefonFirma;
		this.telefonMobilBaustellenVerantwortlicher = telefonMobilBaustellenVerantwortlicher;
	}

	/**
	 * {@inheritDoc}
	 * 
	 * @see de.bsvrz.kex.isis.isis.BaustellenVerantwortlicherInterface#getFirma()
	 */
	public String getFirma() {
		return firma;
	}

	/**
	 * {@inheritDoc}
	 * 
	 * @see de.bsvrz.kex.isis.isis.BaustellenVerantwortlicherInterface#getNameBaustellenVerantwortlicher()
	 */
	public String getNameBaustellenVerantwortlicher() {
		return nameBaustellenVerantwortlicher;
	}

	/**
	 * {@inheritDoc}
	 * 
	 * @see de.bsvrz.kex.isis.isis.BaustellenVerantwortlicherInterface#getTelefonBaustellenVerantwortlicher()
	 */
	public String getTelefonBaustellenVerantwortlicher() {
		return telefonBaustellenVerantwortlicher;
	}

	/**
	 * {@inheritDoc}
	 * 
	 * @see de.bsvrz.kex.isis.isis.BaustellenVerantwortlicherInterface#getTelefonFirma()
	 */
	public String getTelefonFirma() {
		return telefonFirma;
	}

	/**
	 * {@inheritDoc}
	 * 
	 * @see de.bsvrz.kex.isis.isis.BaustellenVerantwortlicherInterface#getTelefonMobilBaustellenVerantwortlicher()
	 */
	public String getTelefonMobilBaustellenVerantwortlicher() {
		return telefonMobilBaustellenVerantwortlicher;
	}

	/**
	 * {@inheritDoc}
	 * 
	 * @see java.lang.Object#toString()
	 */
	@Override
	public String toString() {
		return "Firma: " + firma + " Name: " + nameBaustellenVerantwortlicher
				+ " Telefon: " + telefonBaustellenVerantwortlicher
				+ " Telefon Firma: " + telefonFirma + " Telefon Mobil: "
				+ telefonMobilBaustellenVerantwortlicher;
	}
}
