/*
 * Segment 2 (KEx),  SWE 2.BW-ISIS
 * Copyright (C) 2007 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weienfelser Strae 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.kex.isis.isis.impl;

import de.bsvrz.dav.daf.main.ClientSenderInterface;
import de.bsvrz.dav.daf.main.DataDescription;
import de.bsvrz.dav.daf.main.config.Aspect;
import de.bsvrz.dav.daf.main.config.AttributeGroup;

/**
 * Klasse zur Repr&auml;sentation einer Datenanmeldung am DAV.
 * 
 * @author BitCtrl Systems GmbH, Gieseler
 * @version $Id: DavSendeAnmeldung.java 9155 2008-05-23 16:38:55Z gieseler $
 * 
 */

public class DavSendeAnmeldung extends DataDescription {

	/** der Status der Anmeldung. */
	byte anmeldungsStatus = ClientSenderInterface.STOP_SENDING;

	/**
	 * Konstruktor.
	 * 
	 * @param attributeGroup
	 *            Attributgruppe
	 * @param aspect
	 *            Aspekt
	 */
	public DavSendeAnmeldung(AttributeGroup attributeGroup, Aspect aspect) {
		super(attributeGroup, aspect);
	}

	/**
	 * Test, ob die Anmeldung korrket ist.
	 * 
	 * @return true wenn korrekt, sonst false
	 */
	boolean anmeldungOK() {
		return anmeldungsStatus == ClientSenderInterface.START_SENDING;
	}

	/**
	 * Setzt den Status der Datenanmeldung.
	 * 
	 * @param status
	 *            Status
	 */
	void setzeAnmeldungsStatus(final byte status) {
		anmeldungsStatus = status;
	}

}
