/*
 * Segment 2 (KEx),  SWE 2.BW-ISIS
 * Copyright (C) 2007 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weienfelser Strae 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.kex.isis.isis.impl;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Properties;

import de.bsvrz.dav.daf.main.ClientDavConnection;
import de.bsvrz.dav.daf.main.ClientDavInterface;
import de.bsvrz.dav.daf.main.ClientDavParameters;
import de.bsvrz.dav.daf.main.config.ConfigurationChangeException;
import de.bsvrz.dav.daf.main.config.DataModel;
import de.bsvrz.dav.daf.main.config.SystemObject;
import de.bsvrz.kex.isis.isis.BisInterfaceException;
import de.bsvrz.sys.funclib.bitctrl.kalender.Ereigniskalender;
import de.bsvrz.sys.funclib.bitctrl.modell.AnmeldeException;
import de.bsvrz.sys.funclib.bitctrl.modell.DatensendeException;
import de.bsvrz.sys.funclib.bitctrl.modell.ObjektFactory;
import de.bsvrz.sys.funclib.bitctrl.modell.kalender.objekte.EreignisTyp;
import de.bsvrz.sys.funclib.bitctrl.modell.systemmodellaoe.objekte.AutarkeOrganisationsEinheit;
import de.bsvrz.sys.funclib.commandLineArgs.ArgumentList;

/**
 * Hilfsprogramm (MAIN-Klasse) zum Anlegen des Baustellen-Ereignistyps.
 * 
 * @author BitCtrl Systems GmbH, Gieseler
 * @version $Id: EreignisTypBaustelleAnlegen.java 12578 2008-09-30 08:43:24Z gieseler $
 * 
 */

public class EreignisTypBaustelleAnlegen extends AbstractBIS {

	/**
	 * MAIN-Methode.
	 * 
	 * @param args
	 *            Argumente
	 */
	public static void main(String[] args) {
		EreignisTypBaustelleAnlegen el = new EreignisTypBaustelleAnlegen();
		el.typAnlegen();
		System.exit(0);
	}

	/**
	 * Die benutzte Properties-Datei.
	 */
	private final String propertiesDatei = "isis.properties";

	/**
	 * Die Priorit&auml;t der Baustellen-Ereignisse.
	 */
	private final int baustellenEreignisPrioritaet = 210;

	/**
	 * Stellt die Verbindung zum Datenverteiler her.
	 * 
	 * @param davHost
	 *            Hostname des DAV
	 * @param davUsername
	 *            Nutzername am DAV
	 * @param davPassword
	 *            Passwort des Nutzers
	 * @return Datenverteilerverbindung
	 * @throws BisInterfaceException
	 *             bei Ausnahmen
	 */
	private ClientDavInterface connect(String davHost, String davUsername,
			String davPassword) throws BisInterfaceException {
		ClientDavInterface dav = null;

		ArgumentList argList = new ArgumentList(
				new String[] { "-datenverteiler=" + davHost });
		ClientDavParameters cdp;
		try {
			cdp = new ClientDavParameters(argList);
			cdp.setApplicationName(AbstractBIS.BISAPPNAME);
			dav = new ClientDavConnection(cdp);
			dav.connect();
			dav.login(davUsername, davPassword);
		} catch (Exception e) {
			throw new BisInterfaceException(e.getMessage());
		}
		return dav;
	}

	/**
	 * Legt den Ereignistyp an.
	 */
	private void typAnlegen() {
		try {
			File propfile = new File(propertiesDatei);

			Properties properties = new Properties();
			properties.load(new FileInputStream(propfile));

			ClientDavConnection dav = (ClientDavConnection) connect(properties
					.getProperty(DAV_KEY),
					properties.getProperty(BENUTZER_KEY), properties
							.getProperty(PASSWORT_KEY));
			DataModel config = dav.getDataModel();

			// initialisiere den KV fr die ISIS-Parameterl
			SystemObject kv = config.getObject(properties.getProperty(KV_KEY));
			if (kv == null) {
				throw new BisInterfaceException(
						"Der Konfigurationsverantwortliche '"
								+ properties.getProperty(KV_KEY)
								+ "' kann nicht initialisiert werden");
			}

			if (!kv.getType().getPid().equals("typ.isis")) {
				throw new BisInterfaceException(
						"Der Konfigurationsverantwortliche '"
								+ properties.getProperty(KV_KEY)
								+ "' ist nicht vom Typ 'typ.isis'!");
			}

			ObjektFactory.getInstanz().setVerbindung(dav);
			ObjektFactory.getInstanz().registerStandardFactories();

			// initialisiere AOE
			AutarkeOrganisationsEinheit isisAoe = (AutarkeOrganisationsEinheit) ObjektFactory
					.getInstanz().getModellobjekt(kv);
			
			if (isisAoe == null) {
				throw new BisInterfaceException(
						"Die AutarkeOrganisationsEinheit kann nicht initialisiert werden!");
			}
			
			SystemObject etdav = config
					.getObject(BaustellenEreignisFactory.PID_BAUSTELLENEREIGNIS);
			EreignisTyp ereignisTyp;
			if (etdav == null) {
				System.out.println("Der EreignisTyp '"
						+ BaustellenEreignisFactory.PID_BAUSTELLENEREIGNIS
						+ "' wird angelegt.");

				ereignisTyp = Ereigniskalender.getInstanz().anlegenEreignisTyp(
						BaustellenEreignisFactory.PID_BAUSTELLENEREIGNIS,
						"Baustelle", baustellenEreignisPrioritaet);
				if (ereignisTyp == null) {
					throw new BisInterfaceException(
							"Der Ereignistyp kann nicht angelegt werden!");
				}
			} else {
				System.out.println("Der EreignisTyp "
						+ BaustellenEreignisFactory.PID_BAUSTELLENEREIGNIS
						+ " existiert bereits.");
			}
		} catch (BisInterfaceException e) {
			System.err.println(e.getMessage());
		} catch (FileNotFoundException e) {
			System.err.println("Die Datei '" + propertiesDatei
					+ "' konnte nicht geffnet werden.");
		} catch (IOException e) {
			System.err.println(e.getMessage());
		} catch (ConfigurationChangeException e) {
			System.err.println(e.getMessage());
		} catch (DatensendeException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		} catch (AnmeldeException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}

	}
}
