/*
 * Segment 2 (KEx),  SWE 2.BW-ISIS
 * Copyright (C) 2007 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weienfelser Strae 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.kex.isis.isis.impl;

import de.bsvrz.dav.daf.main.Data;

/**
 * Parameter f&uml;r die Funktionsbibliothek ISIS.
 * 
 * @author BitCtrl Systems GmbH, Gieseler
 * @version $Id: ISISParameter.java 7485 2008-03-17 14:49:20Z gieseler $
 * 
 */
public class ISISParameter {

	/** das Singleton der Klasse. */
	private static ISISParameter singleton;

	/**
	 * Gibt das einzige Objekt der Klasse zur&uuml;ck.
	 * 
	 * @return das Singleton der Klasse.
	 */
	public static ISISParameter getInstance() {
		if (singleton == null) {
			singleton = new ISISParameter();
		}

		return singleton;
	}

	/**
	 * Erzeugt ein Ereignis f&uml;r die Baustelle, wenn diese den Status
	 * 'entworfen' hat (BIS-ISIS: Grobplanung).
	 */
	boolean ereignisBeiEntworfen = false;

	/**
	 * Erzeugt ein Ereignis f&uuml;r die Baustelle, wenn diese den Status
	 * 'geplant' hat (BIS-ISIS: Feinplanung).
	 */
	boolean ereignisBeiGeplant = false;

	/**
	 * Erzeugt ein Ereignis f&uuml;r die Baustelle, wenn diese den Status
	 * 'g&uuml;ltig' hat (BIS-ISIS: Umsetzung).
	 */
	boolean ereignisBeiGueltig = false;

	/**
	 * Erzeugt ein Ereignis f&uuml;r die Baustelle, wenn diese den Status
	 * 'storniert' hat (BIS-ISIS: Gel&ouml;scht).
	 */
	boolean ereignisBeiStorniert = false;

	/**
	 * Zeitdauer in Tagen, bei dem &Auml;nderungen des Baustellenzustandes auf
	 * dem VRZ-System durch Zustands&auml;nderungen beim BIS-ISIS System
	 * quittiert werden m&uuml;ssen, wenn die Baustelle aus Sicht des
	 * VRZ-Systems in n&auml;chsten n-Arbeitstagen (WarnZeitraum) g&uuml;ltig
	 * ist, wird oder war.
	 */
	long warnZeitraum = 0;

	/**
	 * Aktualisiert die Parameter auf des Basis eines von DAV empfangenen
	 * Datensatzes.
	 * 
	 * @param data
	 *            DAV-Datensatz
	 */
	public synchronized void aktualisieren(Data data) {
		ereignisBeiEntworfen = data.getUnscaledValue("EreignisBeiEntworfen")
				.intValue() == 1 ? true : false;
		ereignisBeiGeplant = data.getUnscaledValue("EreignisBeiGeplant")
				.intValue() == 1 ? true : false;
		ereignisBeiGueltig = data.getUnscaledValue("EreignisBeiGltig")
				.intValue() == 1 ? true : false;
		ereignisBeiStorniert = data.getUnscaledValue("EreignisBeiStorniert")
				.intValue() == 1 ? true : false;
		warnZeitraum = data.getTimeValue("WarnZeitraum").getMillis();
	}
}
