/*
 * Segment 2 (KEx),  SWE 2.BW-ISIS
 * Copyright (C) 2007 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weienfelser Strae 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.kex.isis.isis.impl;

import java.util.ArrayList;
import java.util.List;

import de.bsvrz.kex.isis.isis.BisInterfaceException;
import de.bsvrz.kex.isis.isis.OrtsReferenzAsbStationierungInterface;
import de.bsvrz.kex.isis.isis.OrtsReferenzStrasseUndBetriebsKilometerInterface;
import de.bsvrz.kex.isis.isis.OrtsReferenzStrassenSegmentUndOffsetInterface;
import de.bsvrz.sys.funclib.bitctrl.modell.netz.AsbStationierungOrtsReferenz;
import de.bsvrz.sys.funclib.bitctrl.modell.netz.AsbStationierungOrtsReferenzInterface;
import de.bsvrz.sys.funclib.bitctrl.modell.netz.NetzReferenzException;
import de.bsvrz.sys.funclib.bitctrl.modell.netz.NetzReferenzen;
import de.bsvrz.sys.funclib.bitctrl.modell.netz.StrasseUndBetriebsKilometerOrtsReferenzInterface;
import de.bsvrz.sys.funclib.bitctrl.modell.netz.StrassenSegmentUndOffsetOrtsReferenzInterface;
import de.bsvrz.sys.funclib.bitctrl.modell.netz.NetzInterface.ASBStationierungsRichtung;
import de.bsvrz.sys.funclib.operatingMessage.MessageGrade;
import de.bsvrz.sys.funclib.operatingMessage.MessageSender;
import de.bsvrz.sys.funclib.operatingMessage.MessageType;

/**
 * Implementation des OrtsReferenzAsbStationierungInterface.
 * 
 * @author BitCtrl Systems GmbH, Gieseler
 * @version $Id: OrtsReferenzAsbStationierung.java 22186 2010-03-17 09:58:07Z gieseler $
 * 
 */

public class OrtsReferenzAsbStationierung implements
		OrtsReferenzAsbStationierungInterface  {

	/**
	 * Das zugeh&ouml;rige Objekt der Modell-Bibliothek.
	 */
	private AsbStationierungOrtsReferenz modelReferenz;
	
	/**
	 * Erzeugt eine Instanz einer Ortsreferenzen vom ASB-Stationierungssystem.
	 * 
	 * @param anfangsKnoten
	 *            Anfangsknoten der ASB Stationierung
	 * @param endKnoten
	 *            Anfangsknoten der ASB Stationierung
	 * @param richtung
	 *            Stationierungsrichtung fr den ASB Abschnitt
	 * @param stationierung
	 *            Stationierung (in Metern) auf dem ASB Abschnitt
	 */
	public OrtsReferenzAsbStationierung(String anfangsKnoten, String endKnoten,
			ASBStationierungsRichtung richtung, long stationierung) {

		modelReferenz = new AsbStationierungOrtsReferenz(anfangsKnoten, endKnoten, richtung, stationierung);
	}
	
	/**
	 * Erzeugt eine Referenz aus einem Modell-Objekt.
	 * 
	 * @param asbStationierungOrtsReferenzInterface ASB-Stationierungs-Referenz
	 */
	public OrtsReferenzAsbStationierung(AsbStationierungOrtsReferenzInterface asbStationierungOrtsReferenzInterface) {
		this(asbStationierungOrtsReferenzInterface.getAnfangsKnoten(), asbStationierungOrtsReferenzInterface.getEndKnoten(), asbStationierungOrtsReferenzInterface.getAsbStationierungsRichtung(), asbStationierungOrtsReferenzInterface.getStationierung());
	}
	
	/**
	 * {@inheritDoc}
	 * 
	 * @see de.bsvrz.kex.isis.isis.OrtsReferenzAsbStationierungInterface#ermittleOrtsReferenzStrassenSegmentUndOffset()
	 */
	public List<OrtsReferenzStrassenSegmentUndOffsetInterface> ermittleOrtsReferenzStrassenSegmentUndOffset()
			throws BisInterfaceException {
		try {
			List<OrtsReferenzStrassenSegmentUndOffsetInterface> ergebnis = 
				new ArrayList<OrtsReferenzStrassenSegmentUndOffsetInterface>();
			for (StrassenSegmentUndOffsetOrtsReferenzInterface ref 
					: NetzReferenzen.getInstanz()
				.ermittleOrtsReferenzStrassenSegmentUndOffset(modelReferenz)) {
				ergebnis.add(new OrtsReferenzStrassenSegmentUndOffset(ref));
			}
			return ergebnis;
		} catch (NetzReferenzException nre) {
			// versuche Strasse zu finden
			try {
				de.bsvrz.sys.funclib.bitctrl.modell.verkehr.objekte.Strasse strasse = 
					NetzReferenzen.getInstanz().findeStrasse(modelReferenz);
				if (strasse != null) {
					// Betriebsmeldung absetzen
					String meldung = "Die " + this +  " auf Strae '" + strasse + 
							"' konnte nicht auf eine OrtsReferenzStrassenSegmentUndOffset abgebildet werden" +
							" (" + nre.getMessage() +")";
					MessageSender.getInstance().sendMessage(
							MessageType.APPLICATION_DOMAIN,
							MessageGrade.INFORMATION, meldung);
				}
			}
			catch(NetzReferenzException nre2) {
			}
			throw new BisInterfaceException(nre);
		}
	}

	/**
	 * {@inheritDoc}
	 * 
	 * @see de.bsvrz.kex.isis.isis.OrtsReferenzAsbStationierungInterface#ermittleOrtsReferenzStrasseUndBetriebsKilometer()
	 */
	public List<OrtsReferenzStrasseUndBetriebsKilometerInterface> ermittleOrtsReferenzStrasseUndBetriebsKilometer()
			throws BisInterfaceException {
		try {
			List<OrtsReferenzStrasseUndBetriebsKilometerInterface> ergebnis = new ArrayList<OrtsReferenzStrasseUndBetriebsKilometerInterface>();
			for (StrasseUndBetriebsKilometerOrtsReferenzInterface ref 
					: NetzReferenzen.getInstanz().ermittleOrtsReferenzStrasseUndBetriebsKilometer(modelReferenz)) {
				ergebnis.add(new OrtsReferenzStrasseUndBetriebsKilometer(ref));
			}
			return ergebnis;
		} catch (NetzReferenzException nre) {
			throw new BisInterfaceException(nre);
		}
	}

	/**
	 * {@inheritDoc}
	 * 
	 * @see de.bsvrz.kex.isis.isis.OrtsReferenzAsbStationierungInterface#getAnfangsKnoten()
	 */
	public String getAnfangsKnoten() {
		return modelReferenz.getAnfangsKnoten();
	}

	/**
	 * {@inheritDoc}
	 * 
	 * @see de.bsvrz.kex.isis.isis.OrtsReferenzAsbStationierungInterface#getAsbStationierungsRichtung()
	 */
	/**
	 * {@inheritDoc}
	 * 
	 * @see de.bsvrz.kex.isis.isis.OrtsReferenzAsbStationierungInterface#getAsbStationierungsRichtung()
	 */
	public ASBStationierungsRichtung getAsbStationierungsRichtung() {
		return modelReferenz.getAsbStationierungsRichtung();
	}

	/**
	 * {@inheritDoc}
	 * 
	 * @see de.bsvrz.kex.isis.isis.OrtsReferenzAsbStationierungInterface#getEndKnoten()
	 */
	public String getEndKnoten() {
		return modelReferenz.getEndKnoten();
	}

	/**
	 * {@inheritDoc}
	 * 
	 * @see de.bsvrz.kex.isis.isis.OrtsReferenzAsbStationierungInterface#getStationierung()
	 */
	public long getStationierung() {
		return modelReferenz.getStationierung();
	}

	/**
	 * {@inheritDoc}
	 * 
	 * @see java.lang.Object#toString()
	 */
	public String toString() {
		return "ASB-Ortsreferenz (Anfangsknoten: " +
			modelReferenz.getAnfangsKnoten() +
			", Endknoten: " +
			modelReferenz.getEndKnoten() +
			", Stationierung: " +
			modelReferenz.getStationierung() + 
			", Stationierungsrichtung: " +
			modelReferenz.getAsbStationierungsRichtung() +
			")";
	}
}
