/*
 * Segment 2 (KEx),  SWE 2.BW-ISIS
 * Copyright (C) 2007 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weienfelser Strae 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.kex.isis.isis.impl;

import de.bsvrz.kex.isis.isis.BisInterface;
import de.bsvrz.kex.isis.isis.BisInterfaceException;
import de.bsvrz.kex.isis.isis.OrtsReferenzAsbStationierungInterface;
import de.bsvrz.kex.isis.isis.OrtsReferenzStrasseUndBetriebsKilometerInterface;
import de.bsvrz.kex.isis.isis.OrtsReferenzStrassenSegmentUndOffsetInterface;
import de.bsvrz.kex.isis.isis.StrasseInterface;
import de.bsvrz.sys.funclib.bitctrl.modell.netz.NetzReferenzException;
import de.bsvrz.sys.funclib.bitctrl.modell.netz.NetzReferenzen;
import de.bsvrz.sys.funclib.bitctrl.modell.netz.StrasseUndBetriebsKilometerOrtsReferenz;
import de.bsvrz.sys.funclib.bitctrl.modell.netz.StrasseUndBetriebsKilometerOrtsReferenzInterface;
import de.bsvrz.sys.funclib.bitctrl.modell.netz.NetzInterface.FahrtRichtung;
import de.bsvrz.sys.funclib.bitctrl.modell.verkehr.objekte.Strasse;

/**
 * Rep&auml;sentiert eine Ortsreferenz, bei der die Ortsangabe ber eine
 * Stra&szlige und den Betriebskilometer dargestellt wird.
 * 
 * @author BitCtrl Systems GmbH, Gieseler
 * @version $Id: OrtsReferenzStrasseUndBetriebsKilometer.java 12578 2008-09-30 08:43:24Z gieseler $
 * 
 */

public class OrtsReferenzStrasseUndBetriebsKilometer implements
		OrtsReferenzStrasseUndBetriebsKilometerInterface {

	/** Betriebskilometer auf der Stra&szlig;e in Metern. */
	long betriebsKilometer;

	/** Blocknummer des Betriebskilometers auf der Strae. */
	int blockNummer;

	/** Richtung auf dem Stra&szlig;enSegment. */
	BisInterface.FahrtRichtung fahrtRichtung;

	/** Referenzierte Stra&szlig;e. */
	StrasseInterface strasse;
	
	/** das zugeh&ouml;rige Modell-Objekt.	*/
	StrasseUndBetriebsKilometerOrtsReferenz modelReferenz;

	/**
	 * Erzeugt eine Ortsreferenz, bei der die Ortsangabe &uuml;ber eine
	 * Stra&szlig;e und den Betriebskilometer dargestellt wird.
	 * 
	 * @param strasse
	 *            Referenzierte Stra&szlig;e
	 * @param fahrtRichtung
	 *            Richtung auf dem Stra&szlig;enSegment
	 * @param betriebsKilometer
	 *            Betriebskilometer auf der Stra&szlig;e in Metern
	 * @param blockNummer
	 *            Blocknummer des Betriebskilometers auf der Stra&szlig;e
	 */
	public OrtsReferenzStrasseUndBetriebsKilometer(StrasseInterface strasse,
			FahrtRichtung fahrtRichtung, long betriebsKilometer, int blockNummer) {

		de.bsvrz.sys.funclib.bitctrl.modell.verkehr.objekte.Strasse modellstrasse = 
			new de.bsvrz.sys.funclib.bitctrl.modell.verkehr.objekte.Strasse(
					((Strasse) strasse).getSystemObject());
		
		modelReferenz = new StrasseUndBetriebsKilometerOrtsReferenz(modellstrasse,
				fahrtRichtung, betriebsKilometer, blockNummer);
	}

	/**
	 * Erzeugt eine Referenz aus einem Modell-Objekt.
	 * @param ref Strasse-Und-Betriebskilometer-Referenz
	 */
	public OrtsReferenzStrasseUndBetriebsKilometer(
			StrasseUndBetriebsKilometerOrtsReferenzInterface ref) {
		this((StrasseInterface) new Strasse(ref.getStrasse().getSystemObject()), 
				ref.getFahrtRichtung(), ref.getBetriebsKilometer(), ref.getBlockNummer());
	}

	/**
	 * {@inheritDoc}
	 * 
	 * @see de.bsvrz.kex.isis.isis.OrtsReferenzStrasseUndBetriebsKilometerInterface#ermittleOrtsReferenzAsbStationierung()
	 */
	public OrtsReferenzAsbStationierungInterface ermittleOrtsReferenzAsbStationierung()
			throws BisInterfaceException {
		try {
			return new OrtsReferenzAsbStationierung(NetzReferenzen.getInstanz()
					.ermittleOrtsReferenzAsbStationierung(modelReferenz));
		} catch (NetzReferenzException e) {
			throw new BisInterfaceException(e);
		}
	}

	/**
	 * {@inheritDoc}
	 * 
	 * @see de.bsvrz.kex.isis.isis.OrtsReferenzStrasseUndBetriebsKilometerInterface#ermittleOrtsReferenzStrassenSegmentUndOffset()
	 */
	public OrtsReferenzStrassenSegmentUndOffsetInterface ermittleOrtsReferenzStrassenSegmentUndOffset()
			throws BisInterfaceException {
		try {
			return new OrtsReferenzStrassenSegmentUndOffset(NetzReferenzen.getInstanz()
					.ermittleOrtsReferenzStrassenSegmentUndOffset(modelReferenz));
		} catch (NetzReferenzException e) {
			throw new BisInterfaceException(e);
		}
	}

	/**
	 * {@inheritDoc}
	 * 
	 * @see de.bsvrz.kex.isis.isis.OrtsReferenzStrasseUndBetriebsKilometerInterface#getBetriebsKilometer()
	 */
	public long getBetriebsKilometer() {
		return betriebsKilometer;
	}

	/**
	 * {@inheritDoc}
	 * 
	 * @see de.bsvrz.kex.isis.isis.OrtsReferenzStrasseUndBetriebsKilometerInterface#getBlockNummer()
	 */
	public int getBlockNummer() {
		return blockNummer;
	}

	/**
	 * {@inheritDoc}
	 * 
	 * @see de.bsvrz.kex.isis.isis.OrtsReferenzStrasseUndBetriebsKilometerInterface#getFahrtRichtung()
	 */
	public FahrtRichtung getFahrtRichtung() {
		return fahrtRichtung;
	}

	/**
	 * {@inheritDoc}
	 * 
	 * @see de.bsvrz.kex.isis.isis.OrtsReferenzStrasseUndBetriebsKilometerInterface#getStrasse()
	 */
	public StrasseInterface getStrasse() {
		return strasse;
	}

}
