/*
 * Segment 2 (KEx),  SWE 2.BW-ISIS
 * Copyright (C) 2007 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weienfelser Strae 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.kex.isis.isis.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

import de.bsvrz.kex.isis.isis.BisInterfaceException;
import de.bsvrz.kex.isis.isis.MessQuerschnittInterface;
import de.bsvrz.kex.isis.isis.OrtsReferenzAsbStationierungInterface;
import de.bsvrz.kex.isis.isis.OrtsReferenzStrasseUndBetriebsKilometerInterface;
import de.bsvrz.kex.isis.isis.OrtsReferenzStrassenSegmentUndOffsetInterface;
import de.bsvrz.kex.isis.isis.StrassenSegmentInterface;
import de.bsvrz.sys.funclib.bitctrl.modell.netz.NetzReferenzException;
import de.bsvrz.sys.funclib.bitctrl.modell.netz.NetzReferenzen;
import de.bsvrz.sys.funclib.bitctrl.modell.netz.StrassenSegmentUndOffsetOrtsReferenz;
import de.bsvrz.sys.funclib.bitctrl.modell.netz.StrassenSegmentUndOffsetOrtsReferenzInterface;
import de.bsvrz.sys.funclib.bitctrl.modell.verkehr.objekte.MessQuerschnittAllgemein;
import de.bsvrz.sys.funclib.bitctrl.modell.verkehr.objekte.StrassenSegment;

/**
 * Implementation des OrtsReferenzStrassenSegmentUndOffsetInterface.
 * 
 * @author BitCtrl Systems GmbH, Gieseler
 * @version $Id: OrtsReferenzStrassenSegmentUndOffset.java 12578 2008-09-30 08:43:24Z gieseler $
 * 
 */

public class OrtsReferenzStrassenSegmentUndOffset implements
		OrtsReferenzStrassenSegmentUndOffsetInterface, StrassenSegmentInterface {

	/** Offset auf dem StraenSegment in Metern. */
	// private final long startOffset;

	/** das zugeh&ouml;rige ModellObjekt. */
	private final StrassenSegmentUndOffsetOrtsReferenz modelSegment;

	/**
	 * Erzeugt eine neue Ortsreferenz auf der Basis eines Stra&szlig;ensegmentes
	 * und Offsets.
	 * 
	 * @param pidStrassenSegment
	 *            Stra&szlig;ensegment
	 * @param startOffset
	 *            Offset auf dem Stra&szlig;ensegment.
	 * @throws BisInterfaceException
	 *             wenn die Ortsreferenz nicht erzeugt werden kann.
	 */
	public OrtsReferenzStrassenSegmentUndOffset(String pidStrassenSegment,
			long startOffset) throws BisInterfaceException {

		try {
			modelSegment = new StrassenSegmentUndOffsetOrtsReferenz(pidStrassenSegment, startOffset);
		} catch (NetzReferenzException nre) {
			throw new BisInterfaceException(nre);
		}
	}

	/**
	 * Erzeugt eine Referenz aus einem Modell-Objekt.
	 * @param ref SegmentUndOffset-Stationierungs-Referenz
	 * 
	 * @throws BisInterfaceException bei Ausnahmen 
	 */
	public OrtsReferenzStrassenSegmentUndOffset(
			StrassenSegmentUndOffsetOrtsReferenzInterface ref) throws BisInterfaceException {
		this(ref.getStrassenSegment().getPid(), ref.getStartOffset());
	}

	/**
	 * {@inheritDoc}
	 * 
	 * @see de.bsvrz.kex.isis.isis.OrtsReferenzStrassenSegmentUndOffsetInterface#ermittleOrtsReferenzAsbStationierung()
	 */
	public OrtsReferenzAsbStationierungInterface ermittleOrtsReferenzAsbStationierung()
			throws BisInterfaceException {
			try {
				return new OrtsReferenzAsbStationierung(NetzReferenzen.getInstanz()
					.ermittleOrtsReferenzAsbStationierung(modelSegment));
			} catch (NetzReferenzException e) {
				throw new BisInterfaceException(e);
			}
	}

	/**
	 * {@inheritDoc}
	 * 
	 * @see de.bsvrz.kex.isis.isis.OrtsReferenzStrassenSegmentUndOffsetInterface#ermittleOrtsReferenzStrasseUndBetriebsKilometer()
	 */
	public OrtsReferenzStrasseUndBetriebsKilometerInterface ermittleOrtsReferenzStrasseUndBetriebsKilometer()
			throws BisInterfaceException {
		try {
			return new OrtsReferenzStrasseUndBetriebsKilometer(NetzReferenzen.getInstanz()
					.ermittleOrtsReferenzStrasseUndBetriebsKilometer(modelSegment));
		} catch (NetzReferenzException e) {
			throw new BisInterfaceException(e);
		}
	}

	/**
	 * {@inheritDoc}
	 * 
	 * @see de.bsvrz.kex.isis.isis.OrtsReferenzStrassenSegmentUndOffsetInterface#getLaengsNeigung()
	 */
	public Integer getLaengsNeigung() throws BisInterfaceException {
		try {
			return modelSegment.getLaengsNeigung();
		} catch (NetzReferenzException e) {
			throw new BisInterfaceException(e);
		}
	}

//	public Integer getLaengsNeigung() throws BisInterfaceException {
//		float offsetSTS = 0;
//
//		for (StrassenTeilSegment teilseg : modelSegment
//				.getStrassenTeilSegmente()) {
//			if (offsetSTS < startOffset
//					&& startOffset < offsetSTS + teilseg.getLaenge()) {
//				return new Integer(teilseg.getSteigungGefaelle());
//			}
//			offsetSTS += teilseg.getLaenge();
//		}
//
//		throw new BisInterfaceException(
//				"Die Lngsneigung konnte nicht bestimmt werden");
//	}

	/**
	 * Gibt das zugeordnete StrassenSegment der Verkehrsmodells zur&uuml;ck.
	 * 
	 * @return StrassenSegment des Verkehrsmodells
	 */
	public StrassenSegment getModelSegment() {
		return modelSegment.getStrassenSegment();
	}

	/**
	 * {@inheritDoc}
	 * 
	 * @see de.bsvrz.kex.isis.isis.StrassenSegmentInterface#getName()
	 */
	public String getName() {
		return modelSegment.getName();
	}

	/**
	 * {@inheritDoc}
	 * 
	 * @see de.bsvrz.kex.isis.isis.StrassenSegmentInterface#getPid()
	 */
	public String getPid() {
		return modelSegment.getPid();
	}

	/**
	 * {@inheritDoc}
	 * 
	 * @see de.bsvrz.kex.isis.isis.OrtsReferenzStrassenSegmentUndOffsetInterface#getStartOffset()
	 */
	public long getStartOffset() {
		return modelSegment.getStartOffset();
	}

	/**
	 * {@inheritDoc}
	 * 
	 * @see de.bsvrz.kex.isis.isis.OrtsReferenzStrassenSegmentUndOffsetInterface#getStrassenSegment()
	 */
	public StrassenSegmentInterface getStrassenSegment() {
		return this;
	}

	/**
	 * {@inheritDoc}
	 * 
	 * @see de.bsvrz.kex.isis.isis.OrtsReferenzStrassenSegmentUndOffsetInterface#getZuflussMessQuerschnitt()
	 */
	public MessQuerschnittInterface getZuflussMessQuerschnitt()
			throws BisInterfaceException {
		List<MessQuerschnittAllgemein> mqs = modelSegment.getStrassenSegment().getMessquerschnitte();
		List<MessQuerschnittAllgemein> aufsegment = new ArrayList<MessQuerschnittAllgemein>();

		MessQuerschnittAllgemein foundmq = null;

		// bestimme alle MQ auf dem Segment
		for (MessQuerschnittAllgemein mq : mqs) {
			if (mq.getLinie().equals(modelSegment)) {
				aufsegment.add(mq);
			}
		}

		if (aufsegment.size() > 0) {
			// sortieren nach Offset
			Collections.sort(aufsegment,
					new Comparator<MessQuerschnittAllgemein>() {
						public int compare(final MessQuerschnittAllgemein o1,
								final MessQuerschnittAllgemein o2) {
							return new Float(o1.getOffset())
									.compareTo(new Float(o2.getOffset()));
						}
					});

			// passenden suchen
			MessQuerschnittAllgemein vor = null;
			for (MessQuerschnittAllgemein mq : aufsegment) {
				if (mq.getOffset() < modelSegment.getStartOffset()) {
					vor = mq;
				}

				if (foundmq == null || mq.getOffset() > foundmq.getOffset()) {
					foundmq = mq;
				}

				if (foundmq != null && mq.getOffset() > modelSegment.getStartOffset()) {
					break;
				}
			}
			if (vor != null) {
				foundmq = vor;
			}
		}

		if (foundmq != null) {
			return new MessQuerschnitt(foundmq);
		}

		return null;
	}

}
