/*
 * Segment 2 (KEx),  SWE 2.BW-ISIS
 * Copyright (C) 2007 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weienfelser Strae 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.kex.isis.isis.impl;

import de.bsvrz.dav.daf.main.Data;
import de.bsvrz.dav.daf.main.config.AttributeGroup;
import de.bsvrz.dav.daf.main.config.SystemObject;
import de.bsvrz.kex.isis.isis.StrasseInterface;

/**
 * Repr&auml;sentiert eine Stra&szlig;e des BIS-Interface.
 * 
 * @author BitCtrl Systems GmbH, Gieseler
 * @version $Id: Strasse.java 12578 2008-09-30 08:43:24Z gieseler $
 * 
 */
public class Strasse implements StrasseInterface {

	/** das zugeh&ouml;rige Systemobjekt. */
	SystemObject systemobjekt = null;

	/**
	 * Erzeugt ein neues Stra&szlig;enobjekt auf der Basis eines Systemobjektes.
	 * 
	 * @param objekt
	 *            das Systemobjekt der Stra&szlig;e
	 */
	public Strasse(SystemObject objekt) {
		systemobjekt = objekt;
	}

	/**
	 * Gibt das zur Str&szlig;e geh&ouml;rende Systemobjekt zur&uuml;ck.
	 * 
	 * @return Systemobjekt
	 */
	public SystemObject getSystemobjekt() {
		return systemobjekt;
	}

	/**
	 * {@inheritDoc}
	 * 
	 * @see de.bsvrz.kex.isis.isis.StrasseInterface#getName()
	 */
	public String getName() {
		return systemobjekt.getName();
	}

	/**
	 * {@inheritDoc}
	 * 
	 * @see de.bsvrz.kex.isis.isis.StrasseInterface#getPid()
	 */
	public String getPid() {
		return systemobjekt.getPid();
	}

	/**
	 * {@inheritDoc}
	 * 
	 * @see de.bsvrz.kex.isis.isis.StrasseInterface#getStrassenNummer()
	 */
	public int getStrassenNummer() {
		AttributeGroup atg = systemobjekt.getDataModel().getAttributeGroup(
				"atg.strae"); //$NON-NLS-1$
		Data d = systemobjekt.getConfigurationData(atg);

		return (int) d.getUnscaledValue("Nummer").longValue();
	}

	/**
	 * {@inheritDoc}
	 * 
	 * @see de.bsvrz.kex.isis.isis.StrasseInterface#getStrassenTyp()
	 */
	public int getStrassenTyp() {
		AttributeGroup atg = systemobjekt.getDataModel().getAttributeGroup(
				"atg.strae"); //$NON-NLS-1$
		Data d = systemobjekt.getConfigurationData(atg);

		return d.getUnscaledValue("Typ").intValue();
	}

	/**
	 * {@inheritDoc}
	 * 
	 * @see de.bsvrz.kex.isis.isis.StrasseInterface#getZusatz()
	 */
	public String getZusatz() {
		AttributeGroup atg = systemobjekt.getDataModel().getAttributeGroup(
				"atg.strae"); //$NON-NLS-1$
		Data d = systemobjekt.getConfigurationData(atg);

		return d.getTextValue("Zusatz").getText();
	}

	/**
	 * Testet, ob die Stra&szlig;e mit bestimmten Parametern &uuml;bereinstimmt.
	 * 
	 * @param strassenTyp
	 *            Typ der Stra&szlig;e
	 * @param strassenNummer
	 *            Nummer der Stra&szlig;e
	 * @param zusatz
	 *            Zusatz
	 * @return true, wenn die Stra&szlig;e mit den angefragten Parametern
	 *         &uuml:bereinstiimt, sonst false
	 */
	public boolean testeStrassenDaten(int strassenTyp, int strassenNummer,
			String zusatz) {

		return (getStrassenTyp() == strassenTyp)
				&& (getStrassenNummer() == strassenNummer)
				&& zusatz.equals(getZusatz());
	}

}
