package de.bsvrz.kex.isis.isis;

import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

import org.junit.After;
import org.junit.AfterClass;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

import com.bitctrl.resource.Configuration;
import com.bitctrl.util.logging.LoggerTools;

import de.bsvrz.dav.daf.main.ClientDavConnection;
import de.bsvrz.dav.daf.main.ClientSenderInterface;
import de.bsvrz.dav.daf.main.DataDescription;
import de.bsvrz.dav.daf.main.config.ConfigurationObject;
import de.bsvrz.dav.daf.main.config.MutableSet;
import de.bsvrz.dav.daf.main.config.MutableSetChangeListener;
import de.bsvrz.dav.daf.main.config.SystemObject;
import de.bsvrz.sys.funclib.bitctrl.modell.ObjektFactory;

public class BaustellenLoeschen implements MutableSetChangeListener,
		ClientSenderInterface {
	/** Der Logger der Klassse. */
	private static Logger log = Logger.getLogger(BaustellenLoeschen.class
			.getName());

	private static ClientDavConnection verbindung;

	private static String netz = "RDSNetz";;

	/**
	 * Initialisiert den Testfall.
	 * 
	 * @throws Exception
	 *             bei einem Fehler.
	 */
	@BeforeClass
	public static void beforeClass() throws Exception {
		final ObjektFactory factory;

		final Configuration konfig;
		final Level level;

		konfig = Configuration.getConfiguration();
		level = Level.parse(konfig.getString("debug.level"));
		LoggerTools.setLogggerLevel(level);
		log.setLevel(level);

		log.info("Stelle Verbindung zum Datenverteiler her ...");
		verbindung = new ClientDavConnection();
		verbindung.getClientDavParameters().setDavCommunicationAddress(
				konfig.getString("dav.host"));
		verbindung.getClientDavParameters().setDavCommunicationSubAddress(
				konfig.getInt("dav.port"));
		verbindung.connect();
		verbindung.login(konfig.getString("dav.benutzer"), konfig
				.getString("dav.kennwort"));

		factory = ObjektFactory.getInstanz();
		factory.setVerbindung(verbindung);
		factory.registerStandardFactories();
	}

	@BeforeClass
	public static void setUpBeforeClass() throws Exception {
	}

	@AfterClass
	public static void tearDownAfterClass() throws Exception {
	}

	private Object _myLock;

	/*
	 * (non-Javadoc)
	 * 
	 * @see de.bsvrz.dav.daf.main.ClientSenderInterface#dataRequest(de.bsvrz.dav.daf.main.config.SystemObject,
	 *      de.bsvrz.dav.daf.main.DataDescription, byte)
	 */
	public void dataRequest(SystemObject object,
			DataDescription dataDescription, byte state) {
		// TODO Auto-generated method stub

	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see de.bsvrz.dav.daf.main.ClientSenderInterface#isRequestSupported(de.bsvrz.dav.daf.main.config.SystemObject,
	 *      de.bsvrz.dav.daf.main.DataDescription)
	 */
	public boolean isRequestSupported(SystemObject object,
			DataDescription dataDescription) {
		// TODO Auto-generated method stub
		return false;
	}

	@Test
	public void loescheBaustellen() {
		try {
			// initialisiere das Netz
			SystemObject _netz = verbindung.getDataModel().getObject(netz);
			if (_netz == null) {
				throw new BisInterfaceException("Das Netz '" + netz
						+ "' kann nicht initialisiert werden");
			}

			// Baustellen
			MutableSet baustellenmenge = ((ConfigurationObject) _netz)
					.getMutableSet("Baustellen");

			System.out.println("Anzahl der Baustellen im Netz '" + netz + "': "
					+ baustellenmenge.getElements().size());
			List<SystemObject> baustellen = baustellenmenge.getElements();
			if (baustellen.size() != 0) {
				for (SystemObject object : baustellen) {
					System.out.println("Baustelle " + object
							+ " wird gelscht!");
					baustellenmenge.remove(object);
				}
			} else {
				System.out.println("keine Meldungen aus der Menge zu lschen");
			}

			// Baustellen, die nicht in der Menge enthalten sind:
			List<SystemObject> robjekte = verbindung.getDataModel().getType(
					"typ.baustelle").getElements();
			System.out.println("lsche weitere " + robjekte.size()
					+ " Baustellen");
			for (SystemObject so : robjekte) {
				System.out.println("Baustelle " + so + " wird gelscht!");
				so.invalidate();
			}
		} catch (Exception e) {
			e.printStackTrace();
		}
	}

	@Before
	public void setUp() throws Exception {
	}

	@After
	public void tearDown() throws Exception {
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see de.bsvrz.dav.daf.main.config.MutableSetChangeListener#update(de.bsvrz.dav.daf.main.config.MutableSet,
	 *      de.bsvrz.dav.daf.main.config.SystemObject[],
	 *      de.bsvrz.dav.daf.main.config.SystemObject[])
	 */
	public void update(MutableSet set, SystemObject[] addedObjects,
			SystemObject[] removedObjects) {
		System.out.println("gelschte Objekte: " + removedObjects);
	}

}
