/**
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 2 of the License, or (at your option) any later
 * version.
 * 
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 * 
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 51
 * Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 * 
 * Contact Information:<br>
 * BitCtrl Systems GmbH<br>
 * Wei&szlig;enfelser Stra&szlig;e 67<br>
 * 04229 Leipzig<br>
 * Phone: +49 341-490670<br>
 * mailto: info@bitctrl.de
 */

package de.bsvrz.kex.isis.isis;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URL;

import de.bsvrz.dav.daf.main.config.MutableSet;
import de.bsvrz.dav.daf.main.config.SystemObject;
import de.bsvrz.kex.isis.isis.impl.AbstractBIS;

/**
 * @author BitCtrl Systems GmbH, Gieseler
 * @version $Id: BisInterfaceImpl.java 6857 2008-02-21 16:43:11Z gieseler $
 *
 */
public class BisInterfaceImpl extends AbstractBIS {
	
	public static void main(String[] args) {
		BisInterfaceImpl bi = new BisInterfaceImpl();
		bi.run();
	}
	
	public void run() {
		final String propfilename = "de/bsvrz/kex/isis/isis.properties";
		try {
			File propfile =  new File(
					ClassLoader.getSystemResource(propfilename).getFile());
			this.init(propfile.getAbsolutePath());
			BaustellenVerantwortlicherInterface v = erzeugeBaustellenVerantwortlichen(
					"firma", 
					"verantwortlicher", 
					"tel",
					"telf", 
					"telmob");
			String bpid="bpid."+System.currentTimeMillis();
			System.out.println("PID:  " + bpid);
			long bid  = erzeugeBaustelle(bpid, "bname", null, 0, 0, null, 0, BaustellenZustand.ENTWORFEN, 0, v);
			
			try {
				Thread.sleep(10000);
			} catch (InterruptedException e) {
			}
			
		} catch (FileNotFoundException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		} catch (IOException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		} catch (BisInterfaceException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
//		public BaustellenVerantwortlicherInterface erzeugeBaustellenVerantwortlichen(String firma,
//                String nameBaustellenVerantwortlicher,
//                String telefonBaustellenVerantwortlicher,
//                String telefonFirma,
//                String telefonMobilBaustellenVerantwortlicher);

		
//		for(int i=10; i<10000; i++) {
//			String bpid="bpid."+i;
//			System.out.println("PID:  " + bpid);
//			long bid  = erzeugeBaustelle(bpid, "bname", null, 0, 0, null, 0, null, 0, v);
//			try {
//				Thread.sleep(5000);
//			} catch (InterruptedException e) {
//				// TODO Auto-generated catch block
//				e.printStackTrace();
//			}
//		}
		

			System.exit(0);
	}

}
