package de.bsvrz.kex.isis.isis;

import org.junit.After;
import org.junit.AfterClass;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

import de.bsvrz.dav.daf.main.ClientDavConnection;
import de.bsvrz.dav.daf.main.ClientDavInterface;
import de.bsvrz.dav.daf.main.ClientDavParameters;
import de.bsvrz.dav.daf.main.CommunicationError;
import de.bsvrz.dav.daf.main.ConnectionException;
import de.bsvrz.dav.daf.main.InconsistentLoginException;
import de.bsvrz.dav.daf.main.MissingParameterException;
import de.bsvrz.dav.daf.main.config.ConfigurationChangeException;
import de.bsvrz.dav.daf.main.config.DataModel;
import de.bsvrz.dav.daf.main.config.SystemObject;
import de.bsvrz.kex.isis.isis.impl.AbstractBIS;
import de.bsvrz.kex.isis.isis.impl.BaustellenEreignisFactory;
import de.bsvrz.sys.funclib.bitctrl.kalender.Ereigniskalender;
import de.bsvrz.sys.funclib.bitctrl.modell.ObjektFactory;
import de.bsvrz.sys.funclib.bitctrl.modell.kalender.objekte.EreignisTyp;
import de.bsvrz.sys.funclib.commandLineArgs.ArgumentList;

/**
 * @author BitCtrl Systems GmbH, Gieseler
 * @version $Id: EreignisTypBaustelleAnlegen.java 6917 2008-02-22 16:18:48Z
 *          gieseler $
 * 
 */

public class EreignisTypLoeschen extends AbstractBIS {

	public static void main(String[] args) {
		EreignisTypLoeschen el = new EreignisTypLoeschen();
		el.loeschen();
	}

	/**
	 * @throws java.lang.Exception
	 */
	@BeforeClass
	public static void setUpBeforeClass() throws Exception {
	}

	/**
	 * @throws java.lang.Exception
	 */
	@AfterClass
	public static void tearDownAfterClass() throws Exception {
	}

	/**
	 * Stellt die Verbindung zum Datenverteiler her.
	 * 
	 * @param davHost
	 *            Hostname des DAV
	 * @param davUsername
	 *            Nutzername am DAV
	 * @param davPassword
	 *            Passwort des Nutzers
	 * @return Datenverteilerverbindung
	 * @throws MissingParameterException
	 * @throws ConnectionException
	 * @throws CommunicationError
	 * @throws InconsistentLoginException
	 */
	private ClientDavInterface connect(String davHost, String davUsername,
			String davPassword) throws MissingParameterException,
			CommunicationError, ConnectionException, InconsistentLoginException {
		ClientDavInterface dav = null;

		ArgumentList argList = new ArgumentList(
				new String[] { "-datenverteiler=" + davHost });
		ClientDavParameters cdp = new ClientDavParameters(argList);
		// Debug.init(_appName, argList);
		// _debug = Debug.getLogger();

		cdp.setApplicationName(AbstractBIS.BISAPPNAME);
		dav = new ClientDavConnection(cdp);
		dav.connect();
		dav.login(davUsername, davPassword);

		return dav;
	}

	/**
	 */
	@Test
	public void loeschen() {
		try {

			ClientDavConnection _dav = (ClientDavConnection) connect(
					"192.168.1.136:8083", "Tester", "geheim");
			DataModel _config = _dav.getDataModel();

			// initialisiere den KV fr die ISIS-Parameterl
			SystemObject _kv = _config.getObject("kv.bitctrl.isis");
			if (_kv == null) {
				throw new BisInterfaceException(
						"Der Konfigurationsverantwortliche '"
								+ "kv.bitctrl.isis"
								+ "' kann nicht initialisiert werden");
			}

			if (!_kv.getType().getPid().equals("typ.isis")) {
				throw new BisInterfaceException(
						"Der Konfigurationsverantwortliche '"
								+ "kv.bitctrl.isis"
								+ "' ist nicht vom Typ 'typ.isis'!");
			}

			ObjektFactory.getInstanz().setVerbindung(_dav);
			ObjektFactory.getInstanz().registerStandardFactories();

			SystemObject etdav = _config
					.getObject(BaustellenEreignisFactory.PID_BAUSTELLENEREIGNIS);
			EreignisTyp ereignisTyp;

			if (etdav == null) {
				System.out.println("Der EreignisTyp '"
						+ BaustellenEreignisFactory.PID_BAUSTELLENEREIGNIS
						+ "' existiert nicht");
			} else {
				ereignisTyp = (EreignisTyp) ObjektFactory.getInstanz()
						.getModellobjekt(etdav);

				Ereigniskalender.getInstanz().loeschen(ereignisTyp);

				System.out.println("Der EreignisTyp '"
						+ BaustellenEreignisFactory.PID_BAUSTELLENEREIGNIS
						+ "' wurde gelscht");
			}

		} catch (BisInterfaceException e) {
			System.err.println(e.getMessage());
		} catch (MissingParameterException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		} catch (CommunicationError e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		} catch (ConnectionException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		} catch (InconsistentLoginException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		} catch (ConfigurationChangeException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}

	}

	/**
	 * @throws java.lang.Exception
	 */
	@Before
	public void setUp() throws Exception {
	}

	/**
	 * @throws java.lang.Exception
	 */
	@After
	public void tearDown() throws Exception {
	}
}
