/*
 * Segment 2 (KEx),  SWE 2.BW-ISIS
 * Copyright (C) 2007 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weienfelser Strae 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.kex.isis.isis;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;

import com.bitctrl.resource.Configuration;
import com.bitctrl.util.logging.LoggerTools;

import de.bsvrz.sys.funclib.commandLineArgs.ArgumentList;
import de.bsvrz.sys.funclib.debug.Debug;

/**
 * Tools zum Test.
 * 
 * @author BitCtrl Systems GmbH, Gieseler
 * @version $Id: IsisTests.java 13467 2008-10-28 09:52:07Z gieseler $
 * 
 */

public final class IsisTests {
	/** Der Logger der Klassse. */
	private static Logger log = Logger
			.getLogger(TestBaustellenGueltigkeit.class.getName());

	/**
	 * externe Konfiguration.
	 */
	public static Configuration konfig = null;

	/**
	 * Die Interface-Implementation.
	 */
	public static AbstraktBisImpl bisTest = null;
	/**
	 * ID Baustelle 1.
	 */
	public static long baustelle1;

	/**
	 * ID Baustelle 2.
	 */
	public static long baustelle2;

	/**
	 * ID Baustelle 3.
	 */
	public static long baustelle3;

	/**
	 * ID Baustelle 4.
	 */
	public static long baustelle4;

	/**
	 * @throws FileNotFoundException
	 * @throws IOException
	 * @throws BisInterfaceException
	 */
	static void init() throws FileNotFoundException, IOException,
			BisInterfaceException {
		final Level level;

		konfig = Configuration.getConfiguration();
		level = Level.parse(konfig.getString("debug.level"));
		LoggerTools.setLogggerLevel(level);
		log.setLevel(level);

		// String[] commandArguments = {
		ArgumentList al = new ArgumentList(
				new String[] { "-debugLevelStdErrText=" + level });

		Debug.init(TestBaustellenGueltigkeit.class.getName(), al);

		bisTest = new AbstraktBisImpl();
		final String propfilename = konfig.getString("BisPropertyDatei");

		File propfile = new File(propfilename);

		bisTest.init(propfile.getAbsolutePath());
	}

	static void disconnect() {
		bisTest.disconnect();
	}
	
	
	/**
	 * Liest die gespeicherten IDs der Baustellen aus einer Datei aus.
	 * 
	 * @param dateiname
	 *            Datei
	 */
	private static void liesIds(String dateiname) {
		Properties props = new Properties();

		try {
			FileInputStream input = new FileInputStream(new File(dateiname));
			props.load(input);
			baustelle1 = Long.parseLong(props.getProperty("Baustelle1"));
			baustelle2 = Long.parseLong(props.getProperty("Baustelle2"));
			baustelle3 = Long.parseLong(props.getProperty("Baustelle3"));
			baustelle4 = Long.parseLong(props.getProperty("Baustelle4"));
		} catch (FileNotFoundException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		} catch (IOException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}

	}

	/**
	 * Liest die gespeicherten IDs der Baustellen.
	 */
	public static void liesTestbaustellenIds() {
		IsisTests.liesIds(konfig.getString("IdDatei"));
	}

	/**
	 * Berechnet den Beginn des n&auml;chsten Tages.
	 * 
	 * @return Zeitpunkt Beginn des n&auml;chsten Tages
	 */
	public static long naechsterTag() {
		GregorianCalendar naechsterTag = new GregorianCalendar();
		naechsterTag.add(Calendar.DAY_OF_MONTH, +1);
		naechsterTag.set(Calendar.HOUR_OF_DAY, 0);
		naechsterTag.set(Calendar.MINUTE, 0);
		naechsterTag.set(Calendar.SECOND, 0);
		naechsterTag.set(Calendar.MILLISECOND, 0);

		return naechsterTag.getTimeInMillis();
	}

	public static void sichereBaustellenIds() {
		PrintStream ps;
		try {
			File datei = new File(konfig.getString("IdDatei"));
			ps = new PrintStream(datei);
		} catch (FileNotFoundException e) {
			e.printStackTrace();
			return;
		}

		ps.println("# gespeicherte Baustellen-IDs der ISIS-Testumgebung");
		ps.println("Baustelle1=" + baustelle1);
		ps.println("Baustelle2=" + baustelle2);
		ps.println("Baustelle3=" + baustelle3);
		ps.println("Baustelle4=" + baustelle4);

		ps.close();
	}

	/**
	 * Privater Konstruktor.
	 */
	private IsisTests() {
		/**
		 * 
		 */
	}
}
