/*
 * Segment 2 (KEx),  SWE 2.BW-ISIS
 * Copyright (C) 2007 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weienfelser Strae 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.kex.isis.isis;

import static org.junit.Assert.assertNotNull;
import static org.junit.Assert.fail;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.List;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;

import org.junit.After;
import org.junit.BeforeClass;
import org.junit.Test;

import com.bitctrl.resource.Configuration;
import com.bitctrl.util.logging.LoggerTools;

import de.bsvrz.kex.isis.isis.impl.OrtsReferenzAsbStationierung;
import de.bsvrz.sys.funclib.commandLineArgs.ArgumentList;
import de.bsvrz.sys.funclib.debug.Debug;

/**
 * @author BitCtrl Systems GmbH, Gieseler
 * @version $Id: TestBaustellenGueltigkeit.java 9005 2008-05-19 14:53:56Z gieseler $
 * 
 */

public class TestASBinSBK {
	/** Der Logger der Klassse. */
	private static Logger log = Logger
			.getLogger(TestASBinSBK.class.getName());

	/**
	 * externe Konfiguration.
	 */
	private static Configuration konfig = null;

	static AbstraktBisImpl bisTest = null;

	/**
	 * .
	 */
	private static long baustelle1;

	/**
	 * Initialisiert den Testfall.
	 * 
	 * @throws Exception
	 *             bei einem Fehler.
	 */
	@BeforeClass
	public static void beforeClass() throws Exception {

		final Level level;

		konfig = Configuration.getConfiguration();
		level = Level.parse(konfig.getString("debug.level"));
		LoggerTools.setLogggerLevel(level);
		log.setLevel(level);

		// String[] commandArguments = {
		ArgumentList al = new ArgumentList(
				new String[] { "-debugLevelStdErrText=" + level });

		Debug.init(TestASBinSBK.class.getName(), al);

		bisTest = new AbstraktBisImpl();
		final String propfilename = konfig.getString("BisPropertyDatei");

		File propfile = new File(propfilename);

		bisTest.init(propfile.getAbsolutePath());
		//liesIds(konfig.getString("IdDatei"));

	}

	/**
	 * Gibt die Abweichungsliste als Text in eine Datei aus.
	 * 
	 * @param dateiname
	 *            zu schreibende Datei
	 */
	public static void liesIds(String dateiname) {
		Properties props = new Properties();

		try {
			FileInputStream input = new FileInputStream(new File(dateiname));
			props.load(input);
			baustelle1 = Long.parseLong(props.getProperty("Baustelle1"));
		} catch (FileNotFoundException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		} catch (IOException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}

	}

	/**
	 * @throws java.lang.Exception
	 */
	@BeforeClass
	public static void setUpBeforeClass() throws Exception {
		System.out.println("BW-ISIS-Prfungen");
	}

	/**
	 * @throws java.lang.Exception
	 */
	@After
	public void tearDown() throws Exception {
	}

	/**
	 * .
	 */
	@Test
	public void testUmrechnung() {
		try {
			String Anfangsknoten=konfig.getString("Anfangsknoten");
			String Endknoten=konfig.getString("Endknoten");
			long stationierung = Long.parseLong(konfig.getString("Stationierung"));

			System.out.println("Test Referenzierungsumrechnung in Strasse und Betriebskilometer");
			System.out.println("Anfangsknoten: " + Anfangsknoten);
			System.out.println("Endknoten:     " + Endknoten);
			System.out.println("Stationierung: " + stationierung);
			//System.out.println("Richtung:      " + asbref.getAsbStationierungsRichtung());
			
			OrtsReferenzAsbStationierung asbref = new OrtsReferenzAsbStationierung(
					Anfangsknoten, Endknoten, BisInterface.ASBStationierungsRichtung.IN_STATIONIERUNGSRICHTUNG, stationierung);
			
			assertNotNull(asbref);

			List<OrtsReferenzStrasseUndBetriebsKilometerInterface> soref = asbref.ermittleOrtsReferenzStrasseUndBetriebsKilometer();
			
			assertNotNull(soref);
			
			for(OrtsReferenzStrasseUndBetriebsKilometerInterface ref : soref) {
				System.out.println("ermittelte Ortsreferenz:");
				System.out.println("Strasse:            " + ref.getStrasse().getPid());
				System.out.println("Betriebskilometer:  " + ref.getBetriebsKilometer());
				System.out.println("Blocknummer:        " + ref.getBlockNummer());
			}
		} catch (Exception e) {
			System.err.println(e.getMessage());
			fail();
		}

	}
	
}
