/*
 * Segment 2 (KEx),  SWE 2.BW-ISIS
 * Copyright (C) 2007 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weienfelser Strae 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.kex.isis.isis;

import static org.junit.Assert.assertNotNull;
import static org.junit.Assert.fail;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.List;
import java.util.Properties;

import org.junit.After;
import org.junit.BeforeClass;
import org.junit.Test;

import de.bsvrz.kex.isis.isis.impl.OrtsReferenzAsbStationierung;

/**
 * @author BitCtrl Systems GmbH, Gieseler
 * @version $Id: TestBaustellenGueltigkeit.java 9005 2008-05-19 14:53:56Z
 *          gieseler $
 * 
 */

public class TestASBinSSO {

	/**
	 * .
	 */
	private static long baustelle1;

	/**
	 * Initialisiert den Testfall.
	 * 
	 * @throws Exception
	 *             bei einem Fehler.
	 */
	@BeforeClass
	public static void beforeClass() throws Exception {
		IsisTests.init();
	}

	/**
	 * Gibt die Abweichungsliste als Text in eine Datei aus.
	 * 
	 * @param dateiname
	 *            zu schreibende Datei
	 */
	public static void liesIds(String dateiname) {
		Properties props = new Properties();

		try {
			FileInputStream input = new FileInputStream(new File(dateiname));
			props.load(input);
			baustelle1 = Long.parseLong(props.getProperty("Baustelle1"));
		} catch (FileNotFoundException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		} catch (IOException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}

	}

	/**
	 * @throws java.lang.Exception
	 */
	@BeforeClass
	public static void setUpBeforeClass() throws Exception {
		System.out.println("BW-ISIS-Prfungen");
	}

	private void printGanglinie(String name, int[] ganglinie) {
		String glstring = name + ": ";

		for (int i = 0; i < ganglinie.length; i++) {
			if (i > 0) {
				glstring += ", ";
			}

			glstring += String.valueOf(ganglinie[i]);
		}

		System.out.println(glstring);
	}

	/**
	 * @throws java.lang.Exception
	 */
	@After
	public void tearDown() throws Exception {
	}

	/**
	 * .
	 */
	@Test
	public void testUmrechnung() {
		try {
			String Anfangsknoten = IsisTests.konfig.getString("Anfangsknoten");
			String Endknoten = IsisTests.konfig.getString("Endknoten");
			long stationierung = Long.parseLong(IsisTests.konfig
					.getString("Stationierung"));
			String richtung = IsisTests.konfig
					.getString("StationierungsRichtung");
			BisInterface.ASBStationierungsRichtung asbRichtung = null;
			if (richtung.equalsIgnoreCase("IN_STATIONIERUNGSRICHTUNG")) {
				asbRichtung = BisInterface.ASBStationierungsRichtung.IN_STATIONIERUNGSRICHTUNG;
			} else if (richtung
					.equalsIgnoreCase("GEGEN_STATIONIERUNGSRICHTUNG")) {
				asbRichtung = BisInterface.ASBStationierungsRichtung.GEGEN_STATIONIERUNGSRICHTUNG;
			} else {
				fail("Die ASB-Stationierungsrichtung '" + richtung
						+ "' ist nicht zulssig");
			}

			System.out
					.println("Test Referenzierungsumrechnung ASB in Segment und Offset");
			System.out.println("Anfangsknoten: " + Anfangsknoten);
			System.out.println("Endknoten:     " + Endknoten);
			System.out.println("Stationierung: " + stationierung);
			System.out.println("Richtung:      " + asbRichtung);

			OrtsReferenzAsbStationierung asbref = new OrtsReferenzAsbStationierung(
					Anfangsknoten, Endknoten, asbRichtung, stationierung);

			assertNotNull(asbref);

			List<OrtsReferenzStrassenSegmentUndOffsetInterface> soref = asbref
					.ermittleOrtsReferenzStrassenSegmentUndOffset();

			assertNotNull(soref);

			for (OrtsReferenzStrassenSegmentUndOffsetInterface ref : soref) {
				System.out.println("Ortsreferenz:");
				System.out.println("Segment: "
						+ ref.getStrassenSegment().getPid());
				System.out.println("Offset:  " + ref.getStartOffset());
			}
		} catch (Exception e) {
			System.err.println(e.getMessage());
			fail();
		}

	}
}
