/*
 * Segment 2 (KEx),  SWE 2.BW-ISIS
 * Copyright (C) 2007 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weienfelser Strae 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.kex.isis.isis;

import static org.junit.Assert.assertNotNull;
import static org.junit.Assert.fail;

import org.junit.BeforeClass;
import org.junit.Test;

import com.bitctrl.Constants;

import de.bsvrz.kex.isis.isis.BisInterface.BaustellenZustand;

/**
 * Testfall Baustellen anlegen.
 * 
 * @author BitCtrl Systems GmbH, Gieseler
 * @version $Id: TestBaustellenAnlegen.java 9324 2008-05-30 08:33:39Z gieseler $
 * 
 */

public class TestBaustellenAnlegen {
	/**
	 * Prefix der PIDs f&&uml;r die anzulegenden Baustellen.
	 */
	private static final String PIDPREFIX = "Test";

	/**
	 * Initialisiert den Testfall.
	 * 
	 * @throws Exception
	 *             bei einem Fehler.
	 */
	@BeforeClass
	public static void beforeClass() throws Exception {
		IsisTests.init();
	}

	/**
	 * .
	 * 
	 * @throws java.lang.Exception
	 *             bei Ausnahmen
	 */
	@BeforeClass
	public static void setUpBeforeClass() throws Exception {
		System.out.println("BW-ISIS-Prfungen, Prffall 3");
	}

	/**
	 * Test method for
	 * {@link de.bsvrz.kex.isis.isis.impl.AbstractBIS#erzeugeBaustelle(java.lang.String, java.lang.String, java.lang.String, long, long, de.bsvrz.kex.isis.isis.OrtsReferenzStrassenSegmentUndOffsetInterface, long, de.bsvrz.kex.isis.isis.BisInterface.BaustellenZustand, int, de.bsvrz.kex.isis.isis.BaustellenVerantwortlicherInterface)}.
	 */
	@Test
	public void testBaustelleAnlegen() {
		try {
			String baustellenverantwortlichername = "TestBaustellenVerantwortlicher";

			BaustellenVerantwortlicherInterface v = IsisTests.bisTest
					.erzeugeBaustellenVerantwortlichen(
							baustellenverantwortlichername + " firma",
							baustellenverantwortlichername + " name",
							baustellenverantwortlichername + " telefon",
							baustellenverantwortlichername + " telefonFirma",
							baustellenverantwortlichername + " telefonMobil");

			// 2926.80
			OrtsReferenzStrassenSegmentUndOffsetInterface oref = IsisTests.bisTest
					.erzeugeOrtsReferenz(IsisTests.konfig
							.getString("AnlegenSegment"), Long
							.parseLong(IsisTests.konfig
									.getString("AnlegenOffset")));

			assertNotNull(oref);

			System.out.println();
			// Startzeit: 1 ms da Zeit 0 vom Dav abgelehnt wird
			System.out.println("Die Baustelle '" + PIDPREFIX + "1.1.1970" + "' wird angelegt");
			IsisTests.baustelle1 = IsisTests.bisTest.erzeugeBaustelle(PIDPREFIX
					+ "1.1.1970", PIDPREFIX + "Name 1.1.1970", "Info 1.1.1970",
					1, 0, oref, 0, BaustellenZustand.ENTWORFEN, 0, v);

			// Restkapazitt: 100000000 (max im DatK)
			System.out.println("Die Baustelle '" + PIDPREFIX + "jetzt" + "' wird angelegt");
			IsisTests.baustelle2 = IsisTests.bisTest.erzeugeBaustelle(PIDPREFIX
					+ "jetzt", PIDPREFIX + "Name jetzt", "Info jetzt", System
					.currentTimeMillis(), Constants.MILLIS_PER_DAY, oref,
					Long.MAX_VALUE, BaustellenZustand.GEPLANT,
					// Integer.MAX_VALUE,
					100000000, v);

			// Restkapazitt: 0 (min im DatK)
			// Lnge: 0 (neg. lst Exception aus)
			System.out.println("Die Baustelle '" + PIDPREFIX + "nchster_Tag" + "' wird angelegt");
			IsisTests.baustelle3 = IsisTests.bisTest.erzeugeBaustelle(PIDPREFIX
					+ "nchster_Tag", PIDPREFIX + "Name nchster Tag",
					"Info nchster Tag", IsisTests.naechsterTag(),
					7 * Constants.MILLIS_PER_DAY, oref, 0,
					BaustellenZustand.GUELTIG, 0, v);

			System.out.println("Die Baustelle '" + PIDPREFIX + "1.1.1970+MAX_LONG" + "' wird angelegt");
			IsisTests.baustelle4 = IsisTests.bisTest.erzeugeBaustelle(PIDPREFIX
					+ "1.1.1970+MAX_LONG",
					PIDPREFIX + "Name 1.1.1970+MAX_LONG",
					"Info 1.1.1970+MAX_LONG", Long.MAX_VALUE,
					31 * Constants.MILLIS_PER_DAY, oref, 1000,
					BaustellenZustand.STORNIERT, 19, v);

			System.out.println("Baustellen angelegt");
			IsisTests.sichereBaustellenIds();
		} catch (BisInterfaceException e) {
			System.err.println(e);
			fail();
		}

	}
}
