/*
 * Segment 2 (KEx),  SWE 2.BW-ISIS
 * Copyright (C) 2007 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weienfelser Strae 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.kex.isis.isis;

import static org.junit.Assert.assertEquals;
import static org.junit.Assert.fail;

import org.junit.BeforeClass;
import org.junit.Test;

import com.bitctrl.Constants;

/**
 * Testfall &Auml;nderung des G&uuml;ltigkeitszeitraumes der Baustellen.
 * 
 * @author BitCtrl Systems GmbH, Gieseler
 * @version $Id: TestBaustellenGueltigkeit.java 9324 2008-05-30 08:33:39Z gieseler $
 * 
 */

public class TestBaustellenGueltigkeit {

	/**
	 * Initialisiert den Testfall.
	 * 
	 * @throws Exception
	 *             bei einem Fehler.
	 */
	@BeforeClass
	public static void beforeClass() throws Exception {
		IsisTests.init();
		IsisTests.liesTestbaustellenIds();
	}

	/**
	 * .
	 * 
	 * @throws java.lang.Exception
	 *             bei Ausnahmen
	 */
	@BeforeClass
	public static void setUpBeforeClass() throws Exception {
		System.out.println("BW-ISIS-Prfungen, Prffall 3");
	}

	/**
	 * .
	 */
	@Test
	public void testBaustellenGueltigkeit() {
		try {
			System.out.println();
			System.out
					.println("Die Gltigkeitszeitrume der Baustellen werden gendert");

			// Baustelle 1
			BaustelleInterface baustelle = IsisTests.bisTest
					.getBaustelle(IsisTests.baustelle1);
			System.out.println("Die Gltigkeitsdauer der Baustelle "
					+ baustelle.getPid()
					+ " wird auf Start=LONG_MAX, Dauer=7Tage gendert");
			long neuerBeginn = Long.MAX_VALUE;
			long neueDauer = Constants.MILLIS_PER_DAY * 7;

			baustelle.aendereBaustellenGueltigkeitsZeitraum(neuerBeginn,
					neueDauer);

			assertEquals(baustelle.getStartZeitpunkt(), neuerBeginn);
			assertEquals(baustelle.getDauer(), neueDauer);

			// Baustelle 2
			System.out.println("Die Gltigkeitsdauer der Baustelle "
					+ IsisTests.bisTest.getBaustelle(IsisTests.baustelle2)
							.getPid()
					+ " wird auf Start=01.01.1970, Dauer=1Monat gendert");
			neuerBeginn = 1;
			neueDauer = Constants.MILLIS_PER_DAY * 31;
			IsisTests.bisTest.getBaustelle(IsisTests.baustelle2)
					.aendereBaustellenGueltigkeitsZeitraum(neuerBeginn,
							neueDauer);

			assertEquals(IsisTests.bisTest.getBaustelle(IsisTests.baustelle2)
					.getStartZeitpunkt(), neuerBeginn);
			assertEquals(IsisTests.bisTest.getBaustelle(IsisTests.baustelle2)
					.getDauer(), neueDauer);

			// Baustelle 3
			System.out.println("Die Gltigkeitsdauer der Baustelle "
					+ IsisTests.bisTest.getBaustelle(IsisTests.baustelle3)
							.getPid()
					+ " wird auf Start=aktuelleZeit, Dauer=1 gendert");
			neuerBeginn = System.currentTimeMillis();
			neueDauer = 1;
			IsisTests.bisTest.getBaustelle(IsisTests.baustelle3)
					.aendereBaustellenGueltigkeitsZeitraum(neuerBeginn,
							neueDauer);

			assertEquals(IsisTests.bisTest.getBaustelle(IsisTests.baustelle3)
					.getStartZeitpunkt(), neuerBeginn);
			assertEquals(IsisTests.bisTest.getBaustelle(IsisTests.baustelle3)
					.getDauer(), neueDauer);

			// Baustelle 4
			System.out
					.println("Die Gltigkeitsdauer der Baustelle "
							+ IsisTests.bisTest.getBaustelle(
									IsisTests.baustelle4).getPid()
							+ " wird auf Start=nchsterTag,0:00 Uhr, Dauer=1Tag gendert");

			neuerBeginn = IsisTests.naechsterTag();
			neueDauer = Constants.MILLIS_PER_DAY;
			IsisTests.bisTest.getBaustelle(IsisTests.baustelle4)
					.aendereBaustellenGueltigkeitsZeitraum(neuerBeginn,
							neueDauer);

			assertEquals(IsisTests.bisTest.getBaustelle(IsisTests.baustelle4)
					.getStartZeitpunkt(), neuerBeginn);
			assertEquals(IsisTests.bisTest.getBaustelle(IsisTests.baustelle4)
					.getDauer(), neueDauer);

			System.out.println("Gltigkeitszeitrume der Baustellen gendert");

		} catch (BisInterfaceException e) {
			System.err.println(e.getMessage());
			fail();
		}

	}

}
