/*
 * Segment 2 (KEx),  SWE 2.BW-ISIS
 * Copyright (C) 2007 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weienfelser Strae 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.kex.isis.isis;

import static org.junit.Assert.assertEquals;
import static org.junit.Assert.fail;

import org.junit.BeforeClass;
import org.junit.Test;

import com.bitctrl.Constants;

/**
 * Testfall &Auml;nderung der Engpasskapazit&auml;t der Baustellen.
 * 
 * @author BitCtrl Systems GmbH, Gieseler
 * @version $Id: TestBaustellenGueltigkeit.java 9149 2008-05-23 16:35:57Z gieseler $
 * 
 */

public class TestBaustellenKapazitaet {

	/**
	 * Initialisiert den Testfall.
	 * 
	 * @throws Exception
	 *             bei einem Fehler.
	 */
	@BeforeClass
	public static void beforeClass() throws Exception {
		IsisTests.init();
		IsisTests.liesTestbaustellenIds();
	}

	/**
	 * .
	 * 
	 * @throws java.lang.Exception
	 *             bei Ausnahmen
	 */
	@BeforeClass
	public static void setUpBeforeClass() throws Exception {
		System.out.println("BW-ISIS-Prfungen");
	}

	/**
	 * .
	 */
	@Test
	public void testBaustellenKapazitaet() {
		try {
			System.out
					.println("Die Engpasskapazitten der Baustellen werden gendert");

			// Baustelle 1
			int neueKapazitaet = 19;
			BaustelleInterface baustelle = IsisTests.bisTest
					.getBaustelle(IsisTests.baustelle1);
			System.out.println("Die Engpasskapazitt der Baustelle "
					+ baustelle.getPid()
					+ " wird auf " + neueKapazitaet + " Fz/h gendert");

			baustelle.aendereEngpassKapazitaet(neueKapazitaet);
			assertEquals(neueKapazitaet, baustelle.getEngpassKapazitaet());

			// Baustelle 2
			baustelle = IsisTests.bisTest.getBaustelle(IsisTests.baustelle2);
			neueKapazitaet = 0;
			System.out.println("Die Engpasskapazitt der Baustelle "
					+ baustelle.getPid()
					+ " wird auf " + neueKapazitaet + " Fz/h gendert");
			baustelle.aendereEngpassKapazitaet(neueKapazitaet);
			assertEquals(neueKapazitaet, baustelle.getEngpassKapazitaet());

			System.out.println("Die Engpasskapazitten der Baustellen wurden gendert");

		} catch (BisInterfaceException e) {
			System.err.println(e.getMessage());
			fail();
		}

	}

	// WB: 0-100000000
	@Test (expected=BisInterfaceException.class)
	public void testBaustellenKapazitaetUngueltig() throws BisInterfaceException {

		System.out
		.println("Die Engpasskapazitten der Baustellen werden auf ungltige Werte gendert");
		// Baustelle 4
		BaustelleInterface baustelle = IsisTests.bisTest.getBaustelle(IsisTests.baustelle4);
		int neueKapazitaet = Integer.MIN_VALUE;
		System.out.println("Die Engpasskapazitt der Baustelle "
				+ baustelle.getPid()
				+ " wird auf " + neueKapazitaet + " Fz/h gendert");

		baustelle.aendereEngpassKapazitaet(neueKapazitaet);
		
		// Baustelle 3
		baustelle = IsisTests.bisTest.getBaustelle(IsisTests.baustelle3);
		neueKapazitaet = Integer.MAX_VALUE;
		System.out.println("Die Engpasskapazitt der Baustelle "
				+ baustelle.getPid()
				+ " wird auf " + neueKapazitaet + " Fz/h gendert");
		baustelle.aendereEngpassKapazitaet(neueKapazitaet);
		assertEquals(neueKapazitaet, baustelle.getEngpassKapazitaet());

	}
}
