/*
 * Segment 2 (KEx),  SWE 2.BW-ISIS
 * Copyright (C) 2007 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weienfelser Strae 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.kex.isis.isis;

import static org.junit.Assert.assertNotNull;
import static org.junit.Assert.fail;

import org.junit.BeforeClass;
import org.junit.Test;

/**
 * Testfall &Auml;nderung Baustellenort.
 * 
 * @author BitCtrl Systems GmbH, Gieseler
 * @version $Id: $
 */

public class TestBaustellenOrt {
	/**
	 * Initialisiert den Testfall.
	 * 
	 * @throws Exception
	 *             bei einem Fehler.
	 */
	@BeforeClass
	public static void beforeClass() throws Exception {
		IsisTests.init();
		IsisTests.liesTestbaustellenIds();
	}

	/**
	 * .
	 * 
	 * @throws java.lang.Exception
	 *             bei Ausnahmen
	 */
	@BeforeClass
	public static void setUpBeforeClass() throws Exception {
		System.out.println("BW-ISIS-Prfungen, Prffall 3");
	}

	/**
	 * .
	 */
	@Test
	public void testBaustellenOrt() {
		try {
			System.out.println();
			System.out.println("Die Orte der Baustellen werden gendert");

			String neuesSegment = IsisTests.konfig.getString("NeuesSegment");

			OrtsReferenzStrassenSegmentUndOffsetInterface oref = IsisTests.bisTest
					.erzeugeOrtsReferenz(neuesSegment, 2000);

			assertNotNull(oref);

			// Baustelle 1
			BaustelleInterface baustelle = IsisTests.bisTest
					.getBaustelle(IsisTests.baustelle1);

			System.out.println("Der Ort der Baustelle " + baustelle.getPid()
					+ " wird auf " + oref.getStrassenSegment().getPid()
					+ ", Offset: " + oref.getStartOffset() + " gendert");
			baustelle.aendereBaustellenOrt(oref);

			oref = IsisTests.bisTest.erzeugeOrtsReferenz(neuesSegment, 0);
			assertNotNull(oref);
			System.out.println("Der Ort der Baustelle "
					+ IsisTests.bisTest.getBaustelle(IsisTests.baustelle2)
							.getPid() + " wird auf "
					+ oref.getStrassenSegment().getPid() + ", Offset: "
					+ oref.getStartOffset() + " gendert");
			IsisTests.bisTest.getBaustelle(IsisTests.baustelle2)
					.aendereBaustellenOrt(oref);

			System.out.println("Baustellenorte gendert");

		} catch (BisInterfaceException e) {
			System.err.println(e.getMessage());
			fail();
		}

	}

	/**
	 * @throws BisInterfaceException
	 */
	@Test(expected = BisInterfaceException.class)
	public void testBaustellenOrtUngueltig() throws BisInterfaceException {
		System.out.println();
		System.out
				.println("Die Orte der Baustellen werden auf ungltige Werte gendert");

		String neuesSegment = IsisTests.konfig.getString("NeuesSegment");

		OrtsReferenzStrassenSegmentUndOffsetInterface oref = IsisTests.bisTest
				.erzeugeOrtsReferenz(neuesSegment, 3000);

		assertNotNull(oref);

		oref = IsisTests.bisTest.erzeugeOrtsReferenz(neuesSegment,
				Long.MAX_VALUE);
		assertNotNull(oref);
		System.out.println("Der Ort der Baustelle "
				+ IsisTests.bisTest.getBaustelle(IsisTests.baustelle3).getPid()
				+ " wird auf " + oref.getStrassenSegment().getPid()
				+ ", Offset: " + oref.getStartOffset() + " gendert");
		IsisTests.bisTest.getBaustelle(IsisTests.baustelle3)
				.aendereBaustellenOrt(oref);

		oref = IsisTests.bisTest.erzeugeOrtsReferenz(neuesSegment,
				Long.MIN_VALUE);
		assertNotNull(oref);
		System.out.println("Der Ort der Baustelle "
				+ IsisTests.bisTest.getBaustelle(IsisTests.baustelle4).getPid()
				+ " wird auf " + oref.getStrassenSegment().getPid()
				+ ", Offset: " + oref.getStartOffset() + " gendert");
		IsisTests.bisTest.getBaustelle(IsisTests.baustelle4)
				.aendereBaustellenOrt(oref);
	}
}
