/*
 * Segment 2 (KEx),  SWE 2.BW-ISIS
 * Copyright (C) 2007 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weienfelser Strae 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.kex.isis.isis;

import static org.junit.Assert.assertEquals;
import static org.junit.Assert.fail;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.GregorianCalendar;

import org.junit.BeforeClass;
import org.junit.Test;

import de.bsvrz.kex.isis.isis.impl.Baustelle;
import de.bsvrz.sys.funclib.bitctrl.modell.AnmeldeException;
import de.bsvrz.sys.funclib.bitctrl.modell.DatensatzUpdateEvent;
import de.bsvrz.sys.funclib.bitctrl.modell.DatensatzUpdateListener;
import de.bsvrz.sys.funclib.bitctrl.modell.DatensendeException;
import de.bsvrz.sys.funclib.bitctrl.modell.verkehr.onlinedaten.OdBaustellenSimulation;
import de.bsvrz.sys.funclib.bitctrl.modell.verkehr.onlinedaten.OdBaustellenSimulationStarten;
import de.bsvrz.sys.funclib.bitctrl.modell.verkehr.onlinedaten.OdBaustellenSimulation.Daten.StauEintrag;

/**
 * Testfall Baustellensimulation.
 * 
 * @author BitCtrl Systems GmbH, Gieseler
 * @version $Id:$
 * 
 */

public class TestBaustellenSimulation implements DatensatzUpdateListener {

	private static final long MAX_LAENGE_STAU = 10000;

	/**
	 * Initialisiert den Testfall.
	 * 
	 * @throws Exception
	 *             bei einem Fehler.
	 */
	@BeforeClass
	public static void beforeClass() throws Exception {
		IsisTests.init();
		IsisTests.liesTestbaustellenIds();
	}

	/**
	 * .
	 * 
	 * @throws java.lang.Exception bei Ausnahmen
	 */
	@BeforeClass
	public static void setUpBeforeClass() throws Exception {
		System.out.println("BW-ISIS-Prfungen, Prffall 3");
	}

	/**
	 * {@inheritDoc}
	 * 
	 * @see de.bsvrz.sys.funclib.bitctrl.modell.DatensatzUpdateListener#datensatzAktualisiert(de.bsvrz.sys.funclib.bitctrl.modell.DatensatzUpdateEvent)
	 */
	public void datensatzAktualisiert(DatensatzUpdateEvent event) {
		// System.out.println("Aktualisiert: " + event);
		de.bsvrz.sys.funclib.bitctrl.modell.verkehr.objekte.Baustelle baustelle = (de.bsvrz.sys.funclib.bitctrl.modell.verkehr.objekte.Baustelle) event
				.getObjekt();
		OdBaustellenSimulation simuerg = baustelle
				.getOnlineDatensatz(OdBaustellenSimulation.class);
		OdBaustellenSimulation.Daten daten = simuerg.erzeugeDatum();
		StauEintrag eintrag = new StauEintrag();
		eintrag.setMaxLaenge(MAX_LAENGE_STAU);
		eintrag.setMaxLaengeZeit(System.currentTimeMillis() + 60000);
		eintrag.setStartZeit(System.currentTimeMillis());
		eintrag.setVerlustZeit(10000);
		eintrag.setDauer(1000);

		daten.addSchritte(eintrag);
		try {
			simuerg.sendeDaten(OdBaustellenSimulation.Aspekte.PrognoseNormal
					.getAspekt(), daten);
		} catch (DatensendeException e) {
			fail();
		}
	}

	private void simulationAnmelden(Baustelle baustelle)
			throws AnmeldeException {
		OdBaustellenSimulation simu = baustelle.getModellBaustelle()
				.getOnlineDatensatz(OdBaustellenSimulation.class);
		simu.setQuelle(OdBaustellenSimulation.Aspekte.PrognoseNormal
				.getAspekt(), true);
		simu.anmeldenSender(OdBaustellenSimulation.Aspekte.PrognoseNormal
				.getAspekt());

		baustelle.getModellBaustelle().getOnlineDatensatz(
				OdBaustellenSimulation.class)
				.addUpdateListener(
						OdBaustellenSimulation.Aspekte.PrognoseNormal
								.getAspekt(), this);

		OdBaustellenSimulationStarten simustart = baustelle
				.getModellBaustelle().getOnlineDatensatz(
						OdBaustellenSimulationStarten.class);
		simustart.setSenke(OdBaustellenSimulationStarten.Aspekte.Senden
				.getAspekt(), true);
		baustelle.getModellBaustelle().getOnlineDatensatz(
				OdBaustellenSimulationStarten.class).addUpdateListener(
				OdBaustellenSimulationStarten.Aspekte.Senden.getAspekt(), this);
	}

	/**
	 * .
	 */
	@Test
	public void testBaustellenSimulation() {
		try {
			BaustelleInterface baustelle = IsisTests.bisTest
					.getBaustelle(IsisTests.baustelle1);

			if (baustelle == null) {
				System.err.println("Die Testbaustelle kann nicht initialisiert werden!");
				fail();
			}
			
			System.out.println("Fr die Baustelle " + baustelle.getPid()
					+ " wird eine Prognose durchgefhrt");
			simulationAnmelden((Baustelle) baustelle);
			Thread.sleep(1000);
			BaustellenPrognoseInterface prognose = baustelle.startePrognose(
					"TEST", "Testsimulation");

			int anzahl = prognose.getMaximaleStauLaengen().length;

			DateFormat formatter = new SimpleDateFormat();

			for (int i = 0; i < anzahl; i++) {
				GregorianCalendar cala = new GregorianCalendar();
				GregorianCalendar cale = new GregorianCalendar();
				cala.setTimeInMillis(prognose.getStauBeginn()[i]);
				cale.setTimeInMillis(prognose
						.getZeitpunkteDerMaximalenStauLaengen()[i]);
				System.out.println("Ergebnis: ");

				System.out.println("Staubeginn:       "
						+ formatter.format(cala.getTime()));
				System.out.println("Dauer:            "
						+ prognose.getStauDauern()[i]);
				System.out.println("max. Lnge:       "
						+ prognose.getMaximaleStauLaengen()[i]);
				System.out.println("max. Verlustzeit: "
						+ prognose.getMaximaleVerlustzeiten()[i]);
				System.out.println("Zeit max. Lnge:  "
						+ formatter.format(cale.getTime()));
			}

			assertEquals(1, anzahl);
			assertEquals(MAX_LAENGE_STAU, prognose.getMaximaleStauLaengen()[0]);
			System.out.println("Baustellensimulation abgeschlossen");

		} catch (BisInterfaceException e) {
			System.err.println(e.getMessage());
			fail();
		} catch (AnmeldeException e) {
			e.printStackTrace();
			fail();
		} catch (InterruptedException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}

	}
}
