/*
 * Segment 2 (KEx),  SWE 2.BW-ISIS
 * Copyright (C) 2007 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weienfelser Strae 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.kex.isis.isis;

import static org.junit.Assert.assertNotNull;
import static org.junit.Assert.fail;

import java.util.GregorianCalendar;

import org.junit.BeforeClass;
import org.junit.Test;

import com.bitctrl.Constants;

/**
 * Testfall Benachrichtung des Benutzers bei &Auml;derung innerhalb von n-Tagen der Baustellen.
 * 
 * @author BitCtrl Systems GmbH, Gieseler
 * @version $Id:  $
 * 
 */

public class TestBaustellenTage {

	/**
	 * Initialisiert den Testfall.
	 * 
	 * @throws Exception
	 *             bei einem Fehler.
	 */
	@BeforeClass
	public static void beforeClass() throws Exception {
		IsisTests.init();
		IsisTests.liesTestbaustellenIds();
	}

	/**
	 * .
	 * 
	 * @throws java.lang.Exception
	 *             bei Ausnahmen
	 */
	@BeforeClass
	public static void setUpBeforeClass() throws Exception {
		System.out.println("BW-ISIS-Prfungen, Prffall 3");
	}

	/**
	 * .
	 */
	@Test
	public void testBaustellenInfo() {
		try {
			// Baustelle 1
			GregorianCalendar cal = new GregorianCalendar();
			cal.setTimeInMillis(System.currentTimeMillis()+Constants.MILLIS_PER_DAY*2);

			BaustelleInterface baustelle = IsisTests.bisTest
					.getBaustelle(IsisTests.baustelle1);
			
			assertNotNull(baustelle);
			
			System.out.println("Der Beginn der Gltigkeit der Baustelle "
					+ baustelle.getPid()
					+ " wird auf 'in 2 Tagen' gendert");

			baustelle.aendereBaustellenZustand(BisInterface.BaustellenZustand.GEPLANT);
			baustelle.aendereBaustellenGueltigkeitsZeitraum(cal.getTimeInMillis(), 10000);
			baustelle.aendereBaustellenZustand(BisInterface.BaustellenZustand.GUELTIG);
			
			cal.setTimeInMillis(System.currentTimeMillis() + (Constants.MILLIS_PER_DAY*10));
			System.out.println("Der Beginn der Gltigkeit der Baustelle "
					+ baustelle.getPid()
					+ " wird auf 'in 10 Tagen' gendert");
			
			baustelle.aendereBaustellenZustand(BisInterface.BaustellenZustand.GEPLANT);
			baustelle.aendereBaustellenGueltigkeitsZeitraum(cal.getTimeInMillis(), 10000);
			baustelle.aendereBaustellenZustand(BisInterface.BaustellenZustand.GUELTIG);
			
		} catch (BisInterfaceException e) {
			System.err.println(e.getMessage());
			fail();
		}

	}

}
