/*
 * Segment 2 (KEx),  SWE 2.BW-ISIS
 * Copyright (C) 2007 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weienfelser Strae 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.kex.isis.isis;

import static org.junit.Assert.assertEquals;
import static org.junit.Assert.fail;

import org.junit.BeforeClass;
import org.junit.Test;

/**
 * Testfall &Auml;nderung des Baustellenverantwortlichen.
 * 
 * @author BitCtrl Systems GmbH, Gieseler
 * @version $Id: TestBaustellenVerantwortlicher.java 9324 2008-05-30 08:33:39Z gieseler $
 * 
 */

public class TestBaustellenVerantwortlicher {

	/**
	 * Initialisiert den Testfall.
	 * 
	 * @throws Exception
	 *             bei einem Fehler.
	 */
	@BeforeClass
	public static void beforeClass() throws Exception {
		IsisTests.init();
		IsisTests.liesTestbaustellenIds();
	}

	/**
	 * .
	 * 
	 * @throws java.lang.Exception
	 *             bei Ausnahmen
	 */
	@BeforeClass
	public static void setUpBeforeClass() throws Exception {
		System.out.println("BW-ISIS-Prfungen, Prffall 3");
	}

	/**
	 * .
	 */
	@Test
	public void testBaustellenVerantwortlicher() {
		try {
			// Baustelle 1
			BaustelleInterface baustelle = IsisTests.bisTest
					.getBaustelle(IsisTests.baustelle1);

			System.out.println("Der Baustellenverantwortliche der Baustelle '"
					+ baustelle.getName() + "' wird gendert");

			BaustellenVerantwortlicherInterface aktuell = baustelle
					.getBaustellenVerantwortlichen();
			System.out.println("Aktueller Baustellenverantwortlicher: "
					+ aktuell);

			BaustellenVerantwortlicherInterface neu = IsisTests.bisTest
					.erzeugeBaustellenVerantwortlichen(aktuell
							.getNameBaustellenVerantwortlicher()
							+ " NEU", aktuell
							.getNameBaustellenVerantwortlicher()
							+ " NEU", aktuell
							.getTelefonBaustellenVerantwortlicher()
							+ " NEU", aktuell.getTelefonFirma() + " NEU",
							aktuell.getTelefonMobilBaustellenVerantwortlicher()
									+ " NEU");

			System.out.println("Neuer Baustellenverantwortlicher:     " + neu);

			baustelle.aendereBaustellenVerantwortlichen(neu);

			assertEquals(aktuell.getNameBaustellenVerantwortlicher() + " NEU",
					baustelle.getBaustellenVerantwortlichen()
							.getNameBaustellenVerantwortlicher());

			System.out.println("Der Baustellenverantwortliche wurde gendert");

		} catch (BisInterfaceException e) {
			System.err.println(e.getMessage());
			fail();
		}

	}

}
