/*
 * Segment 2 (KEx),  SWE 2.BW-ISIS
 * Copyright (C) 2007 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weienfelser Strae 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.kex.isis.isis;

import static org.junit.Assert.assertEquals;
import static org.junit.Assert.fail;

import org.junit.BeforeClass;
import org.junit.Test;

/**
 * Testfall Baustellenzustand ndern.
 * 
 * @author BitCtrl Systems GmbH, Gieseler
 * @version $Id: TestBaustellenGueltigkeit.java 9005 2008-05-19 14:53:56Z gieseler $
 * 
 */

public class TestBaustellenZustand {

	/**
	 * .
	 */
	/**
	 * Initialisiert den Testfall.
	 * 
	 * @throws Exception
	 *             bei einem Fehler.
	 */
	@BeforeClass
	public static void beforeClass() throws Exception {
		IsisTests.init();
		IsisTests.liesTestbaustellenIds();
	}

	/**
	 * .
	 * @throws java.lang.Exception bei Ausnahmen
	 */
	@BeforeClass
	public static void setUpBeforeClass() throws Exception {
		System.out.println("BW-ISIS-Prfungen, Prffall 3");
	}


	/**
	 * .
	 */
	@Test
	public void testBaustellenZustand() {
		try {
			System.out
					.println("Die Zustnde der Baustellen werden gendert");

			BaustelleInterface baustelle = IsisTests.bisTest.getBaustelle(IsisTests.baustelle1);

			System.out.println("Der Zustand der Baustelle " + baustelle.getPid() 
					+ " wird auf " + BisInterface.BaustellenZustand.STORNIERT + " gendert");
			baustelle.aendereBaustellenZustand(BisInterface.BaustellenZustand.STORNIERT);
			assertEquals(BisInterface.BaustellenZustand.STORNIERT, baustelle.getBaustellenZustand());
			
			baustelle = IsisTests.bisTest.getBaustelle(IsisTests.baustelle2);
			System.out.println("Der Ort der Baustelle " + baustelle.getPid()
					+ " wird auf " + BisInterface.BaustellenZustand.ENTWORFEN + " gendert");
			baustelle.aendereBaustellenZustand(BisInterface.BaustellenZustand.ENTWORFEN);
			assertEquals(BisInterface.BaustellenZustand.ENTWORFEN, baustelle.getBaustellenZustand());

			baustelle = IsisTests.bisTest.getBaustelle(IsisTests.baustelle3);
			System.out.println("Der Ort der Baustelle " + baustelle.getPid()
					+ " wird auf " + BisInterface.BaustellenZustand.GEPLANT + " gendert");
			baustelle.aendereBaustellenZustand(BisInterface.BaustellenZustand.GEPLANT);
			assertEquals(BisInterface.BaustellenZustand.GEPLANT, baustelle.getBaustellenZustand());
			
			baustelle = IsisTests.bisTest.getBaustelle(IsisTests.baustelle4);
			System.out.println("Der Ort der Baustelle " + baustelle.getPid()
					+ " wird auf " + BisInterface.BaustellenZustand.GUELTIG + " gendert");
			baustelle.aendereBaustellenZustand(BisInterface.BaustellenZustand.GUELTIG);
			assertEquals(BisInterface.BaustellenZustand.GUELTIG, baustelle.getBaustellenZustand());
			
			System.out.println("Baustellenzustnde gendert");

		} catch (BisInterfaceException e) {
			System.err.println(e.getMessage());
			fail();
		}

	}
}
