/*
 * Segment 2 (KEx),  SWE 2.BW-ISIS
 * Copyright (C) 2007 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weienfelser Strae 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.kex.isis.isis;

import static org.junit.Assert.assertNotNull;
import static org.junit.Assert.fail;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.text.DateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Iterator;

import org.junit.BeforeClass;
import org.junit.Test;

import com.bitctrl.Constants;
import com.bitctrl.util.Interval;

import de.bsvrz.dav.daf.main.config.ConfigurationChangeException;
import de.bsvrz.iav.gllib.gllib.Stuetzstelle;
import de.bsvrz.iav.gllib.gllib.dav.GanglinieMQ;
import de.bsvrz.iav.gllib.gllib.dav.Ganglinienprognose;
import de.bsvrz.iav.gllib.gllib.dav.Messwerte;
import de.bsvrz.iav.gllib.gllib.modell.parameter.PdGanglinie;
import de.bsvrz.kex.isis.isis.impl.BaustellenEreignisFactory;
import de.bsvrz.kex.isis.isis.impl.MessQuerschnitt;
import de.bsvrz.sys.funclib.bitctrl.kalender.Ereigniskalender;
import de.bsvrz.sys.funclib.bitctrl.modell.AnmeldeException;
import de.bsvrz.sys.funclib.bitctrl.modell.DatensendeException;
import de.bsvrz.sys.funclib.bitctrl.modell.ObjektFactory;
import de.bsvrz.sys.funclib.bitctrl.modell.kalender.objekte.Ereignis;
import de.bsvrz.sys.funclib.bitctrl.modell.kalender.objekte.EreignisTyp;
import de.bsvrz.sys.funclib.bitctrl.modell.verkehr.objekte.MessQuerschnittAllgemein;

/**
 * Testfall Ganglinienabfrage.
 * 
 * @author BitCtrl Systems GmbH, Gieseler
 * @version $Id: TestGanglinien.java 9324 2008-05-30 08:33:39Z gieseler $
 * 
 */

public class TestGanglinien {
	/**
	 * Initialisiert den Testfall.
	 * 
	 * @throws Exception
	 *             bei einem Fehler.
	 */
	@BeforeClass
	public static void beforeClass() throws Exception {
		IsisTests.init();
		if (!Ganglinienprognose.getInstanz().isBereit()) {
			fail("Die Ganglinienprognose ist nicht bereit");
		}

		if (!Ereigniskalender.getInstanz().isBereit()) {
			fail("Der Ereigniskalender ist nicht bereit");
		}
	}

	/**
	 * .
	 * 
	 * @throws java.lang.Exception
	 *             bei Ausnahmen
	 */
	@BeforeClass
	public static void setUpBeforeClass() throws Exception {
		System.out.println("BW-ISIS-Prfungen, Prffall 3");
	}

	private Ereignis ereignis;
	MessQuerschnittAllgemein mq;

	/**
	 * Ein zur Ganglinie passendes Ereignis wird angelegt.
	 * 
	 * @param start
	 *            Startzeitpunkt
	 * @param ende
	 *            Endzeitpunkt
	 * @return Ereignis
	 * @throws ConfigurationChangeException
	 * @throws AnmeldeException
	 * @throws DatensendeException
	 * @throws BisInterfaceException
	 * @throws FileNotFoundException
	 * @throws IOException
	 */
	private Ereignis anlegenEreignis(GregorianCalendar start,
			GregorianCalendar ende) throws ConfigurationChangeException,
			AnmeldeException, DatensendeException, BisInterfaceException,
			FileNotFoundException, IOException {

		String pid = "Testereignis" + System.currentTimeMillis();
		String name = "Testereignis Name";
		String beschreibung = "Angelegt zum Ganglinientest";

		String quelle = "ISIS-Test";
		EreignisTyp ereignisTyp = (EreignisTyp) ObjektFactory.getInstanz()
				.getModellobjekt(
						BaustellenEreignisFactory.PID_BAUSTELLENEREIGNIS);

		Interval intervall = new Interval(start.getTimeInMillis(), ende
				.getTimeInMillis());

		ereignis = Ereigniskalender.getInstanz().anlegenEreignis(pid, name,
				beschreibung, ereignisTyp, intervall, quelle);

		return ereignis;
	}

	private void gangLinieAnlegen(MessQuerschnittInterface mqi) {

		PdGanglinie param;
		PdGanglinie.Daten datum;

		mq = ((MessQuerschnitt) mqi).getMessQuerschnitt();

		param = mq.getParameterDatensatz(PdGanglinie.class);
		try {
			param.anmeldenSender();
			datum = param.erzeugeDatum();
			GanglinieMQ g;
			g = new GanglinieMQ();
			g.setMessQuerschnitt(mq);
			g.setApproximationDaK(GanglinieMQ.APPROX_POLYLINE);
			g.setEreignisTyp((EreignisTyp) ObjektFactory.getInstanz()
					.getModellobjekt("ereignisTyp.Baustelle"));
			g.setReferenz(true);

			Messwerte messwerte;
			Number qKfz, qLkw, vPkw, vLkw;

			qKfz = 1000;
			qLkw = 500;
			vPkw = 100;
			vLkw = 80;
			messwerte = new Messwerte(qKfz != null ? qKfz.doubleValue() : null,
					qLkw != null ? qLkw.doubleValue() : null,
					vPkw != null ? vPkw.doubleValue() : null,
					vLkw != null ? vLkw.doubleValue() : null);
			g.setStuetzstelle(new Stuetzstelle<Messwerte>(0, messwerte));
			g.setStuetzstelle(new Stuetzstelle<Messwerte>(
					Constants.MILLIS_PER_DAY, messwerte));

			datum.add(g);
			param.sendeDaten(datum, 60 * 1000);
			System.out.println("Ganglinien fr " + mq + " gesendet.");

		} catch (final AnmeldeException ex) {
			System.err.println("Kann mich nicht zum Senden der Ganglinien fr "
					+ mq + " anmelden.");
		} catch (final DatensendeException ex) {
			System.err.println("Kann Ganglinien fr " + mq + " nicht senden.");
		}

		param.abmeldenSender();
	}

	private void printGanglinien(GanglinienInterface[] gli) {

		if (gli.length == 0) {
			System.out.println("Keine Ganglinien");
		} else {
			for (GanglinienInterface g : gli) {
				System.out.println("Ganglinie Datum: "
						+ DateFormat.getDateTimeInstance().format(
								new Date(g.getDatum())) + ", "
						+ g.getQKfz().length + " Sttzstellen");

				printGanglinienWerte("QKfz", g.getQKfz());
				printGanglinienWerte("QLkw", g.getQLkw());
				printGanglinienWerte("QPkw", g.getQPkw());
				printGanglinienWerte("VKfz", g.getVKfz());
				printGanglinienWerte("VLkw", g.getVLkw());
				printGanglinienWerte("VPkw", g.getVPkw());
			}
		}
	}

	private void printGanglinienWerte(String name, int[] ganglinie) {
		String glstring = name + ": ";

		for (int i = 0; i < ganglinie.length; i++) {
			if (i > 0) {
				glstring += ", ";
			}

			glstring += String.valueOf(ganglinie[i]);
		}

		System.out.println(glstring);
	}

	/**
	 * .
	 */
	@Test
	public void testGanglinien1() {
		try {
			System.out
					.println("Die Ganglinien der Baustellen werden abgefragt!");

			// MessQuerschnittInterface mqi = bisTest.getBaustelle(baustelle1)
			// .getOrtsReferenzStrassenSegmentUndOffset()
			// .getZuflussMessQuerschnitt();

			MessQuerschnittAllgemein mqa = (MessQuerschnittAllgemein) ObjektFactory
					.getInstanz().getModellobjekt(
							IsisTests.konfig.getString("GanglinieMQ"));
			assertNotNull(mqa);

			MessQuerschnitt mq = new MessQuerschnitt(mqa);

			assertNotNull(mq);

			System.out.println("TEST-MQ: " + mq.getPid());

			GregorianCalendar start = new GregorianCalendar();
			start.set(Calendar.DAY_OF_MONTH, 1);
			start.set(Calendar.MONTH, Calendar.JANUARY);
			start.set(Calendar.YEAR, 1970);
			start.set(Calendar.HOUR_OF_DAY, 1);
			start.set(Calendar.MINUTE, 0);
			start.set(Calendar.SECOND, 0);
			start.set(Calendar.MILLISECOND, 0);

			GregorianCalendar ende = (GregorianCalendar) start.clone();
			ende.add(Calendar.DAY_OF_MONTH, +2);

			System.out.println("Start: "
					+ DateFormat.getDateTimeInstance().format(
							new Date(start.getTimeInMillis())));
			System.out.println("Ende:  "
					+ DateFormat.getDateTimeInstance().format(
							new Date(ende.getTimeInMillis())));
			GanglinienInterface[] gli = mq.getGanglinien(start
					.getTimeInMillis(), ende.getTimeInMillis());

			printGanglinien(gli);
			System.out.println("Die Ganglinien wurden abgefragt");

		} catch (BisInterfaceException e) {
			System.err.println(e.getMessage());
		}

	}

	/**
	 * .
	 */
	@Test
	public void testGanglinien2() {
		try {
			System.out
					.println("Die Ganglinien der Baustellen werden abgefragt!");

			// MessQuerschnittInterface mqi = bisTest.getBaustelle(baustelle1)
			// .getOrtsReferenzStrassenSegmentUndOffset()
			// .getZuflussMessQuerschnitt();

			MessQuerschnittAllgemein mqa = (MessQuerschnittAllgemein) ObjektFactory
					.getInstanz().getModellobjekt(
							IsisTests.konfig.getString("GanglinieMQ"));
			assertNotNull(mqa);

			MessQuerschnitt mq = new MessQuerschnitt(mqa);

			assertNotNull(mq);

			System.out.println("TEST-MQ: " + mq.getPid());

			GregorianCalendar start = new GregorianCalendar();
			start.add(Calendar.DAY_OF_MONTH, -2);
			start.set(Calendar.HOUR_OF_DAY, 0);
			start.set(Calendar.MINUTE, 0);
			start.set(Calendar.SECOND, 0);
			start.set(Calendar.MILLISECOND, 0);

			GregorianCalendar ende = new GregorianCalendar();
			ende.add(Calendar.DAY_OF_MONTH, +2);
			ende.set(Calendar.HOUR_OF_DAY, 24);
			ende.set(Calendar.MINUTE, 0);
			ende.set(Calendar.SECOND, 0);
			ende.set(Calendar.MILLISECOND, 0);

			anlegenEreignis(start, ende);
			gangLinieAnlegen(mq);

			System.out.println("Start: "
					+ DateFormat.getDateTimeInstance().format(
							new Date(start.getTimeInMillis())));
			System.out.println("Ende:  "
					+ DateFormat.getDateTimeInstance().format(
							new Date(ende.getTimeInMillis())));
			GanglinienInterface[] gli = mq.getGanglinien(start
					.getTimeInMillis(), ende.getTimeInMillis());

			printGanglinien(gli);
			System.out.println("Die Ganglinien wurden abgefragt");

		} catch (BisInterfaceException e) {
			System.err.println(e.getMessage());
		} catch (ConfigurationChangeException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		} catch (FileNotFoundException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		} catch (AnmeldeException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		} catch (DatensendeException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		} catch (IOException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		} finally {
			if (ereignis != null) {
				try {
					PdGanglinie g = mq.getParameterDatensatz(PdGanglinie.class);
					PdGanglinie.Daten gd = g.abrufenDatum();
					Iterator<GanglinieMQ> git = gd.iterator();
					while (git.hasNext()) {
						GanglinieMQ gmq = git.next();
						if (ereignis.getEreignisTyp().equals(
								gmq.getEreignisTyp())) {
							git.remove();
						}
					}

					Ereigniskalender.getInstanz().loeschen(ereignis);
				} catch (ConfigurationChangeException e) {
					// TODO Auto-generated catch block
					e.printStackTrace();
				}
			}
		}

	}
}
