/*
 * Segment 2 (KEx),  SWE 2.BW-ISIS
 * Copyright (C) 2007 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weienfelser Strae 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.kex.isis.isis;

import static org.junit.Assert.assertNotNull;

import java.util.List;

import org.junit.BeforeClass;
import org.junit.Test;

import de.bsvrz.kex.isis.isis.impl.OrtsReferenzAsbStationierung;

/**
 * Testfall Umrechnung Ortsreferenezn.
 * 
 * @author BitCtrl Systems GmbH, Gieseler
 * @version $Id: TestISB1.java 12481 2008-09-26 14:21:06Z gieseler $
 * 
 */

public class TestISB1 {
	/**
	 * Initialisiert den Testfall.
	 * 
	 * @throws Exception
	 *             bei einem Fehler.
	 */
	@BeforeClass
	public static void beforeClass() throws Exception {
		IsisTests.init();
	}

	/**
	 * .
	 * 
	 * @throws java.lang.Exception
	 *             bei Ausnahmen
	 */
	@BeforeClass
	public static void setUpBeforeClass() throws Exception {
		System.out.println("BW-ISIS-Prfungen, Testfall ISB 1");
	}

	String anfangsKnoten = "7912009K";

	String endKnoten = "7912009J";

	double maxStationierung = 0.284 * 1000;

	/**
	 * Test method for.
	 * 
	 * @throws BisInterfaceException
	 */
	// @Test
	public void testISB_ASB(String anfangsKnoten, String endKnoten,
			long stationierung, BisInterface.ASBStationierungsRichtung asbRichtung)
			throws BisInterfaceException {
		System.out
				.println("Test Referenzierungsumrechnung ASB in Segment und Offset");
		System.out.println("Anfangsknoten: " + anfangsKnoten);
		System.out.println("Endknoten:     " + endKnoten);
		System.out.println("Stationierung: " + stationierung);
		System.out.println("Richtung:      " + asbRichtung);

		OrtsReferenzAsbStationierungInterface oref = new OrtsReferenzAsbStationierung(
				anfangsKnoten, endKnoten, asbRichtung, stationierung);

		assertNotNull(oref);

		List<OrtsReferenzStrassenSegmentUndOffsetInterface> orefkonv = oref
				.ermittleOrtsReferenzStrassenSegmentUndOffset();

		int i = 0;
		for (OrtsReferenzStrassenSegmentUndOffsetInterface ref : orefkonv) {
			i++;
			System.out.println("Ortsreferenz " + i + ":");
			System.out.println("Segment: " + ref.getStrassenSegment().getPid());
			System.out.println("Offset:  " + ref.getStartOffset());
			MessQuerschnittInterface mq = ref.getZuflussMessQuerschnitt();
			if (mq != null) {
				System.out.println("Zufluss-MQ: " + mq.getPid() + " ("
						+ mq.getName() + ")");
			} else {
				System.out.println("Kein Zufluss-MQ!");
			}
		}

		System.out.println();

		// String segment = IsisTests.konfig.getString("Segment");
		// long offset =
		// Long.parseLong(IsisTests.konfig.getString("Offset"));
		//
		// assertEquals(1, orefkonv.size());
		// assertEquals(segment,
		// orefkonv.get(0).getStrassenSegment().getPid());
		// assertEquals((long) 999, orefkonv.get(0).getStartOffset());

	}

	/**
	 * Test method for.
	 */
	@Test
	public void testISB1() {
		try {
			testISB_ASB(
					anfangsKnoten,
					endKnoten,
					0,
					BisInterface.ASBStationierungsRichtung.IN_STATIONIERUNGSRICHTUNG);
		} catch (BisInterfaceException e) {
			System.out.println(e.getMessage());
		}

		try {
			testISB_ASB(
					anfangsKnoten,
					endKnoten,
					(long) maxStationierung,
					BisInterface.ASBStationierungsRichtung.IN_STATIONIERUNGSRICHTUNG);
		} catch (BisInterfaceException e) {
			System.out.println(e.getMessage());
		}

		try {
			testISB_ASB(
					anfangsKnoten,
					endKnoten,
					0,
					BisInterface.ASBStationierungsRichtung.GEGEN_STATIONIERUNGSRICHTUNG);
		} catch (BisInterfaceException e) {
			System.out.println(e.getMessage());
		}

		try {
			testISB_ASB(

					anfangsKnoten,
					endKnoten,
					(long) maxStationierung,
					BisInterface.ASBStationierungsRichtung.GEGEN_STATIONIERUNGSRICHTUNG);

		} catch (BisInterfaceException e) {
			System.out.println(e.getMessage());
		}
	}

}
