/*
 * Segment 2 (KEx),  SWE 2.BW-ISIS
 * Copyright (C) 2007 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weienfelser Strae 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.kex.isis.isis;

import static org.junit.Assert.assertNotNull;

import java.util.List;

import org.junit.BeforeClass;
import org.junit.Test;

import de.bsvrz.kex.isis.isis.BisInterface.BaustellenZustand;
import de.bsvrz.kex.isis.isis.impl.OrtsReferenzAsbStationierung;
import de.bsvrz.sys.funclib.bitctrl.modell.netz.NetzInterface.ASBStationierungsRichtung;

/**
 * Testfall gemeldete Fehler.
 * 
 * @author BitCtrl Systems GmbH, Gieseler
 * @version $Id: TestISB1.java 12481 2008-09-26 14:21:06Z gieseler $
 * 
 */

public class TestISB2 {
	/**
	ASBStationierungsRichtung.IN_STATIONIERUNGSRICHTUNG == true
	ASBStationierungsRichtung.GEGEN_STATIONIERUNGSRICHTUNG == false
	*/
	
	/** Fehler 1: VNK: 6417028 NNK: 6517065 Station: 0 Stationierung: false Lnge: 1100. */
	OrtsReferenzAsbStationierung isbAsbFehler1 = new OrtsReferenzAsbStationierung(
			"6417028", "6517065", ASBStationierungsRichtung.GEGEN_STATIONIERUNGSRICHTUNG, 0);
	/**
	 * Laenge.
	 */
	int isbAsbFehler1Laenge = 1100;
	
	/** Fehler 2: VNK: 6724061 NNK: 6824069 Station: 3690 Stationierung: true Lnge: 3300. */
	OrtsReferenzAsbStationierung isbAsbFehler2 = new OrtsReferenzAsbStationierung(
			"6724061", "6824069", ASBStationierungsRichtung.IN_STATIONIERUNGSRICHTUNG, 3690);
	/**
	 * Laenge.
	 */
	int isbAsbFehler2Laenge = 3300;
	
	/** Fehler 4: VNK: 6417061 NNK: 6517059 Station: 0 Stationierung: false Lnge: 7700. */
	OrtsReferenzAsbStationierung isbAsbFehler4 = new OrtsReferenzAsbStationierung(
			"6417061", "6517059", ASBStationierungsRichtung.GEGEN_STATIONIERUNGSRICHTUNG, 0);
	/**
	 * Laenge.
	 */
	int isbAsbFehler4Laenge = 7000;
	
	/** Fehler 5: VNK: 6824069 NNK: 6825049 Station: 2850 Stationierung: false Lnge: 3300. */
	OrtsReferenzAsbStationierung isbAsbFehler5 = new OrtsReferenzAsbStationierung(
			"6824069", "6825049", ASBStationierungsRichtung.GEGEN_STATIONIERUNGSRICHTUNG, 0);
	/**
	 * Laenge.
	 */
	int isbAsbFehler5Laenge = 3300;	
	
	/**
	 * Initialisiert den Testfall.
	 * 
	 * @throws Exception
	 *             bei einem Fehler.
	 */
	@BeforeClass
	public static void beforeClass() throws Exception {
		IsisTests.init();
	}

	/**
	 * .
	 * 
	 * @throws java.lang.Exception
	 *             bei Ausnahmen
	 */
	@BeforeClass
	public static void setUpBeforeClass() throws Exception {
		System.out.println("BW-ISIS-Prfungen, Testfall ISB 2");
	}

	/**
	 * Test method for.
	 * @param asbref Ortsreferenz
	 * @param laenge L&auml;nge
	 * @param name Name
	 * @param verantw Verantwortlicher
	 * 
	 * @throws BisInterfaceException bei Ausnahmen
	 */
	// @Test
	public void testIsbBaustelle(OrtsReferenzAsbStationierung asbref, int laenge, String name,
			BaustellenVerantwortlicherInterface verantw)
			throws BisInterfaceException {
		System.out
				.println("Test Referenzierungsumrechnung ASB in Segment und Offset");
		System.out.println("Anfangsknoten: " + asbref.getAnfangsKnoten());
		System.out.println("Endknoten:     " + asbref.getEndKnoten());
		System.out.println("Stationierung: " + asbref.getStationierung());
		System.out.println("Richtung:      " + asbref.getAsbStationierungsRichtung());

		List<OrtsReferenzStrassenSegmentUndOffsetInterface> oref = null;
		try {
			oref = asbref.ermittleOrtsReferenzStrassenSegmentUndOffset();
		} catch (BisInterfaceException e) {
			e.printStackTrace();
		}

		assertNotNull(oref);

		int i = 0;
		for (OrtsReferenzStrassenSegmentUndOffsetInterface ref : oref) {
			i++;
			String bname = name + i;
			System.out.println("Ortsreferenz " + i + ":");
			System.out.println("Segment: " + ref.getStrassenSegment().getPid());
			System.out.println("Offset:  " + ref.getStartOffset());
			
			IsisTests.bisTest.erzeugeBaustelle(bname, bname, bname, 
					System.currentTimeMillis(), 0, ref, laenge, BaustellenZustand.GUELTIG, 
					0, verantw);
			System.out.println("Baustelle: " + bname + " angelegt!");
		}

		System.out.println();
	}

	
	/**
	 * Test method for.
	 */
	@Test
	public void testISB1() {
		BaustellenVerantwortlicherInterface v = IsisTests.bisTest.erzeugeBaustellenVerantwortlichen(
				"firma", 
				"verantwortlicher", 
				"tel",
				"telf", 
				"telmob");
		
		try {
			testIsbBaustelle(isbAsbFehler5, isbAsbFehler5Laenge, "Fehler_5_", v);
		} catch (BisInterfaceException e) {
			System.out.println(e.getMessage());
		}
	}

}
