/*
 * Segment 2 (KEx),  SWE 2.BW-ISIS
 * Copyright (C) 2007 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weienfelser Strae 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.kex.isis.isis;

import static org.junit.Assert.assertEquals;
import static org.junit.Assert.assertNotNull;
import static org.junit.Assert.fail;

import java.util.List;

import org.junit.BeforeClass;
import org.junit.Test;

import de.bsvrz.kex.isis.isis.impl.OrtsReferenzAsbStationierung;
import de.bsvrz.kex.isis.isis.impl.OrtsReferenzStrasseUndBetriebsKilometer;
import de.bsvrz.kex.isis.isis.impl.OrtsReferenzStrassenSegmentUndOffset;

/**
 * Testfall Umrechnung Ortsreferenezn.
 * 
 * @author BitCtrl Systems GmbH, Gieseler
 * @version $Id: TestOrtsReferenzen.java 12481 2008-09-26 14:21:06Z gieseler $
 * 
 */

public class TestOrtsReferenzen {
	/**
	 * Initialisiert den Testfall.
	 * 
	 * @throws Exception
	 *             bei einem Fehler.
	 */
	@BeforeClass
	public static void beforeClass() throws Exception {
		IsisTests.init();
	}

	/**
	 * .
	 * 
	 * @throws java.lang.Exception
	 *             bei Ausnahmen
	 */
	@BeforeClass
	public static void setUpBeforeClass() throws Exception {
		System.out
				.println("BW-ISIS-Prfungen, Testfall Umrechung Ortsreferenzen");
	}

	/**
	 * Test method for
	 * {@link de.bsvrz.kex.isis.isis.OrtsReferenzStrasseUndBetriebsKilometerInterface#ermittleOrtsReferenzStrassenSegmentUndOffset()}.
	 */
	@Test
	public void testErmittleOrtsReferenzStrassenSegmentUndOffsetAusSBK() {
		try {
			String strassenPid = IsisTests.konfig.getString("Strasse");
			long bkm = Long.parseLong(IsisTests.konfig
					.getString("Betriebskilometer"));
			int blocknummer = Integer.parseInt(IsisTests.konfig
					.getString("Blocknummer"));
			String richtung = IsisTests.konfig.getString("Fahrtrichtung");
			BisInterface.FahrtRichtung fahrtRichtung = null;
			if (richtung.equalsIgnoreCase("IN_RICHTUNG")) {
				fahrtRichtung = BisInterface.FahrtRichtung.IN_RICHTUNG;
			} else if (richtung.equalsIgnoreCase("GEGEN_RICHTUNG")) {
				fahrtRichtung = BisInterface.FahrtRichtung.GEGEN_RICHTUNG;
			} else {
				fail("Die Fahrtrichtungsangabe '" + richtung
						+ "' ist nicht zulssig");
			}

			StrasseInterface strasse = IsisTests.bisTest
					.getStrasse(strassenPid);
			assertNotNull(strasse);

			OrtsReferenzStrasseUndBetriebsKilometerInterface oref = new OrtsReferenzStrasseUndBetriebsKilometer(
					strasse, fahrtRichtung, bkm, blocknummer);

			assertNotNull(oref);

			OrtsReferenzStrassenSegmentUndOffsetInterface orefkonv = oref
					.ermittleOrtsReferenzStrassenSegmentUndOffset();

			String segment = IsisTests.konfig.getString("Segment");
			long offset = Long.parseLong(IsisTests.konfig.getString("Offset"));

			assertEquals(segment, orefkonv.getStrassenSegment().getPid());
			assertEquals((long) 159, orefkonv.getStartOffset());

		} catch (BisInterfaceException e) {
			fail(e.getMessage());
		}
	}
	
	@Test (expected=BisInterfaceException.class)
	public void testErmittleOrtsReferenzStrassenSegmentUndOffsetAusSBK_FehlerStrasse() throws BisInterfaceException {
			System.out.println();
			System.out.println("Die Orte der Baustellen werden auf ungltige Werte gendert");

			String strassenPid = "A999";
			long bkm = Long.parseLong(IsisTests.konfig
					.getString("Betriebskilometer"));
			int blocknummer = Integer.parseInt(IsisTests.konfig
					.getString("Blocknummer"));
			String richtung = IsisTests.konfig.getString("Fahrtrichtung");
			BisInterface.FahrtRichtung fahrtRichtung = null;
			if (richtung.equalsIgnoreCase("IN_RICHTUNG")) {
				fahrtRichtung = BisInterface.FahrtRichtung.IN_RICHTUNG;
			} else if (richtung.equalsIgnoreCase("GEGEN_RICHTUNG")) {
				fahrtRichtung = BisInterface.FahrtRichtung.GEGEN_RICHTUNG;
			} else {
				fail("Die Fahrtrichtungsangabe '" + richtung
						+ "' ist nicht zulssig");
			}

			StrasseInterface strasse = IsisTests.bisTest
					.getStrasse(strassenPid);
			assertNotNull(strasse);
	}
	
	/**
	 * Test method for
	 * {@link de.bsvrz.kex.isis.isis.OrtsReferenzStrasseUndBetriebsKilometerInterface#ermittleOrtsReferenzStrassenSegmentUndOffset()}.
	 * @throws BisInterfaceException 
	 */
	@Test (expected=BisInterfaceException.class)
	public void testErmittleOrtsReferenzStrassenSegmentUndOffsetAusSBK_FehlerBetriebskilometer() throws BisInterfaceException {
		String strassenPid = IsisTests.konfig.getString("Strasse");
		long bkm = 1;
		int blocknummer = Integer.parseInt(IsisTests.konfig
					.getString("Blocknummer"));
		String richtung = IsisTests.konfig.getString("Fahrtrichtung");
		BisInterface.FahrtRichtung fahrtRichtung = null;
		if (richtung.equalsIgnoreCase("IN_RICHTUNG")) {
			fahrtRichtung = BisInterface.FahrtRichtung.IN_RICHTUNG;
		} else if (richtung.equalsIgnoreCase("GEGEN_RICHTUNG")) {
			fahrtRichtung = BisInterface.FahrtRichtung.GEGEN_RICHTUNG;
		} else {
			fail("Die Fahrtrichtungsangabe '" + richtung
					+ "' ist nicht zulssig");
		}
		StrasseInterface strasse = IsisTests.bisTest
				.getStrasse(strassenPid);
		assertNotNull(strasse);
		OrtsReferenzStrasseUndBetriebsKilometerInterface oref = new OrtsReferenzStrasseUndBetriebsKilometer(
				strasse, fahrtRichtung, bkm, blocknummer);
		assertNotNull(oref);

		OrtsReferenzStrassenSegmentUndOffsetInterface orefkonv = oref
				.ermittleOrtsReferenzStrassenSegmentUndOffset();

		String segment = IsisTests.konfig.getString("Segment");
		long offset = Long.parseLong(IsisTests.konfig.getString("Offset"));
		assertEquals(segment, orefkonv.getStrassenSegment().getPid());
		assertEquals(159, orefkonv.getStartOffset());
	}
	
	/**
	 * .
	 */
	@Test
	public void testErmittleOrtsReferenzStrasseUndBetriebskilometerAusSSO() {
			try {
			String segment = IsisTests.konfig.getString("Segment");
			long offset = Long.parseLong(IsisTests.konfig.getString("Offset"));

			System.out.println("Test Referenzierungsumrechnung Segment "
					+ segment + ", Offset " + offset
					+ " in Strae und Betriebskilometer");

			OrtsReferenzStrassenSegmentUndOffsetInterface oref = new OrtsReferenzStrassenSegmentUndOffset(
					segment, offset);
			assertNotNull(oref);

			OrtsReferenzStrasseUndBetriebsKilometerInterface ref = oref
					.ermittleOrtsReferenzStrasseUndBetriebsKilometer();
			System.out.println("ermittelte Ortsreferenz:");
			System.out.println("Strasse:            "
					+ ref.getStrasse().getName());
			System.out.println("Betriebskilometer:  "
					+ ref.getBetriebsKilometer());
			System.out.println("Blocknummer:        " + ref.getBlockNummer());
			
			assertEquals(ref.getStrasse().getPid(), IsisTests.konfig.getString("Strasse"));
			assertEquals((long) 588841, ref.getBetriebsKilometer());
			assertEquals(ref.getBlockNummer(), Integer.parseInt(IsisTests.konfig.getString("Blocknummer")));
		} catch (Exception e) {
			System.err.println(e.getMessage());
			fail();
		}

	}

	/**
	 * .
	 * @throws BisInterfaceException 
	 */
	@Test (expected=BisInterfaceException.class)
	public void testErmittleOrtsReferenzStrasseUndBetriebskilometerAusSSO_FehlerSegment() throws BisInterfaceException {
			String segment = "ass.n.55555.n.55554.0";
			long offset = Long.parseLong(IsisTests.konfig.getString("Offset"));

			System.out.println("Test Referenzierungsumrechnung Segment "
					+ segment + ", Offset " + offset
					+ " in Strae und Betriebskilometer");

			OrtsReferenzStrassenSegmentUndOffsetInterface oref = new OrtsReferenzStrassenSegmentUndOffset(
					segment, offset);
			assertNotNull(oref);

			OrtsReferenzStrasseUndBetriebsKilometerInterface ref = oref
					.ermittleOrtsReferenzStrasseUndBetriebsKilometer();
			System.out.println("ermittelte Ortsreferenz:");
			System.out.println("Strasse:            "
					+ ref.getStrasse().getName());
			System.out.println("Betriebskilometer:  "
					+ ref.getBetriebsKilometer());
			System.out.println("Blocknummer:        " + ref.getBlockNummer());
			
			assertEquals(ref.getStrasse().getPid(), IsisTests.konfig.getString("Strasse"));
			assertEquals(588841, ref.getBetriebsKilometer());
			assertEquals(ref.getBlockNummer(), Integer.parseInt(IsisTests.konfig.getString("Blocknummer")));
	}
	
	/**
	 * .
	 * @throws BisInterfaceException 
	 */
	@Test (expected=BisInterfaceException.class)
	public void testErmittleOrtsReferenzStrasseUndBetriebskilometerAusSSO_FehlerOffset() throws BisInterfaceException {
		String segment = IsisTests.konfig.getString("Segment");
			long offset = 100000;

			System.out.println("Test Referenzierungsumrechnung Segment "
					+ segment + ", Offset " + offset
					+ " in Strae und Betriebskilometer");

			OrtsReferenzStrassenSegmentUndOffsetInterface oref = new OrtsReferenzStrassenSegmentUndOffset(
					segment, offset);
			assertNotNull(oref);

			OrtsReferenzStrasseUndBetriebsKilometerInterface ref = oref
					.ermittleOrtsReferenzStrasseUndBetriebsKilometer();
			System.out.println("ermittelte Ortsreferenz:");
			System.out.println("Strasse:            "
					+ ref.getStrasse().getName());
			System.out.println("Betriebskilometer:  "
					+ ref.getBetriebsKilometer());
			System.out.println("Blocknummer:        " + ref.getBlockNummer());
			
			assertEquals(ref.getStrasse().getPid(), IsisTests.konfig.getString("Strasse"));
			assertEquals(588841, ref.getBetriebsKilometer());
			assertEquals(ref.getBlockNummer(), Integer.parseInt(IsisTests.konfig.getString("Blocknummer")));
	}
	
	/**
	 * Test method for
	 * {@link de.bsvrz.kex.isis.isis.OrtsReferenzAsbStationierungInterface#ermittleOrtsReferenzStrassenSegmentUndOffset()}.
	 */
	@Test
	public void testErmittleOrtsReferenzStrasseUndBetriebskilometerAusASB() {
	try {
		String anfangsknoten = IsisTests.konfig.getString("Anfangsknoten");
		String endknoten = IsisTests.konfig.getString("Endknoten");
		long stationierung = Long.parseLong(IsisTests.konfig.getString("Stationierung"));

		System.out.println("Test Referenzierungsumrechnung ASB in Strasse und Betriebskilometer");
		System.out.println("Anfangsknoten: " + anfangsknoten);
		System.out.println("Endknoten:     " + endknoten);
		System.out.println("Stationierung: " + stationierung);
		//System.out.println("Richtung:      " + asbref.getAsbStationierungsRichtung());
		
		OrtsReferenzAsbStationierung asbref = new OrtsReferenzAsbStationierung(
				anfangsknoten, endknoten, BisInterface.ASBStationierungsRichtung.IN_STATIONIERUNGSRICHTUNG, stationierung);
		
		assertNotNull(asbref);

		List<OrtsReferenzStrasseUndBetriebsKilometerInterface> soref = asbref.ermittleOrtsReferenzStrasseUndBetriebsKilometer();
		
		assertNotNull(soref);
		
		for (OrtsReferenzStrasseUndBetriebsKilometerInterface ref : soref) {
			System.out.println("ermittelte Ortsreferenz:");
			System.out.println("Strasse:            " + ref.getStrasse().getPid());
			System.out.println("Betriebskilometer:  " + ref.getBetriebsKilometer());
			System.out.println("Blocknummer:        " + ref.getBlockNummer());
		}
	} catch (Exception e) {
		System.err.println(e.getMessage());
		fail();
	}
	}
	
	/**
	 * Test method for
	 * {@link de.bsvrz.kex.isis.isis.OrtsReferenzAsbStationierungInterface#ermittleOrtsReferenzStrassenSegmentUndOffset()}.
	 * @throws BisInterfaceException 
	 */
	@Test (expected=BisInterfaceException.class)
	public void testErmittleOrtsReferenzStrasseUndBetriebskilometerAusASB_FehlerStationierung() throws BisInterfaceException {
		String anfangsknoten = IsisTests.konfig.getString("Anfangsknoten");
		String endknoten = IsisTests.konfig.getString("Endknoten");
		long stationierung = 10000;

		System.out.println("Test Referenzierungsumrechnung ASB in Strasse und Betriebskilometer");
		System.out.println("Anfangsknoten: " + anfangsknoten);
		System.out.println("Endknoten:     " + endknoten);
		System.out.println("Stationierung: " + stationierung);
		//System.out.println("Richtung:      " + asbref.getAsbStationierungsRichtung());
		
		OrtsReferenzAsbStationierung asbref = new OrtsReferenzAsbStationierung(
				anfangsknoten, endknoten, BisInterface.ASBStationierungsRichtung.IN_STATIONIERUNGSRICHTUNG, stationierung);
		
		assertNotNull(asbref);

		List<OrtsReferenzStrasseUndBetriebsKilometerInterface> soref = asbref.ermittleOrtsReferenzStrasseUndBetriebsKilometer();
		
		assertNotNull(soref);
		
		for (OrtsReferenzStrasseUndBetriebsKilometerInterface ref : soref) {
			System.out.println("ermittelte Ortsreferenz:");
			System.out.println("Strasse:            " + ref.getStrasse().getPid());
			System.out.println("Betriebskilometer:  " + ref.getBetriebsKilometer());
			System.out.println("Blocknummer:        " + ref.getBlockNummer());
		}
	}
	
	/**
	 * Test method for
	 * {@link de.bsvrz.kex.isis.isis.OrtsReferenzAsbStationierungInterface#ermittleOrtsReferenzStrassenSegmentUndOffset()}.
	 */
	@Test
	public void testErmittleOrtsReferenzStrassenSegmentUndOffsetAusASB() {
		try {
			String anfangsKnoten = IsisTests.konfig.getString("Anfangsknoten");
			String endKnoten = IsisTests.konfig.getString("Endknoten");
			long stationierung = Long.parseLong(IsisTests.konfig
					.getString("Stationierung"));
			String richtung = IsisTests.konfig
					.getString("StationierungsRichtung");
			BisInterface.ASBStationierungsRichtung asbRichtung = null;
			if (richtung.equalsIgnoreCase("IN_STATIONIERUNGSRICHTUNG")) {
				asbRichtung = BisInterface.ASBStationierungsRichtung.IN_STATIONIERUNGSRICHTUNG;
			} else if (richtung
					.equalsIgnoreCase("GEGEN_STATIONIERUNGSRICHTUNG")) {
				asbRichtung = BisInterface.ASBStationierungsRichtung.GEGEN_STATIONIERUNGSRICHTUNG;
			} else {
				fail("Die ASB-Stationierungsrichtung '" + richtung
						+ "' ist nicht zulssig");
			}

			System.out.println("Test Referenzierungsumrechnung ASB in Segment und Offset");
			System.out.println("Anfangsknoten: " + anfangsKnoten);
			System.out.println("Endknoten:     " + endKnoten);
			System.out.println("Stationierung: " + stationierung);
			System.out.println("Richtung:      " + asbRichtung);
			
			OrtsReferenzAsbStationierungInterface oref = new OrtsReferenzAsbStationierung(
					anfangsKnoten, endKnoten, asbRichtung, stationierung);

			assertNotNull(oref);

			List<OrtsReferenzStrassenSegmentUndOffsetInterface> orefkonv = oref
					.ermittleOrtsReferenzStrassenSegmentUndOffset();

			for (OrtsReferenzStrassenSegmentUndOffsetInterface ref : orefkonv) {
				System.out.println("Ortsreferenz:");
				System.out.println("Segment: "
						+ ref.getStrassenSegment().getPid());
				System.out.println("Offset:  " + ref.getStartOffset());
			}
				
			String segment = IsisTests.konfig.getString("Segment");
			long offset = Long.parseLong(IsisTests.konfig.getString("Offset"));

			assertEquals(1, orefkonv.size());
			assertEquals(segment, orefkonv.get(0).getStrassenSegment().getPid());
			assertEquals((long) 999, orefkonv.get(0).getStartOffset());

		} catch (BisInterfaceException e) {
			fail(e.getMessage());
		}
	}



	/**
	 * .
	 */
	@Test
	public void testErmittleOrtsReferenzASBausSSO() {
		try {
			String segment = IsisTests.konfig.getString("Segment");
			long offset = Long.parseLong(IsisTests.konfig.getString("Offset"));

			System.out.println("Test Referenzierungsumrechnung Segment "
					+ segment + ", Offset " + offset + " in ASB-Stationierung");

			OrtsReferenzStrassenSegmentUndOffsetInterface oref = new OrtsReferenzStrassenSegmentUndOffset(
					segment, offset);
			assertNotNull(oref);

			OrtsReferenzAsbStationierungInterface asbref = oref
					.ermittleOrtsReferenzAsbStationierung();

			System.out.println("Anfangsknoten: " + asbref.getAnfangsKnoten());
			System.out.println("Endknoten:     " + asbref.getEndKnoten());
			System.out.println("Stationierung: " + asbref.getStationierung());
			System.out.println("Richtung:      "
					+ asbref.getAsbStationierungsRichtung());
			
			assertEquals("6617008O", asbref.getAnfangsKnoten());
			assertEquals("6717023", asbref.getEndKnoten());
			assertEquals((long)1118, asbref.getStationierung());
			assertEquals(BisInterface.ASBStationierungsRichtung.IN_STATIONIERUNGSRICHTUNG, asbref.getAsbStationierungsRichtung());


		} catch (Exception e) {
			System.err.println(e.getMessage());
			fail();
		}

	}
	
	/**
	 * .
	 * @throws BisInterfaceException 
	 */
	@Test (expected=BisInterfaceException.class)
	public void testErmittleOrtsReferenzASBausSSO_FehlerSegment() throws BisInterfaceException {
			String segment = "ass.n.55555.n.55554.0";
			long offset = Long.parseLong(IsisTests.konfig.getString("Offset"));

			System.out.println("Test Referenzierungsumrechnung Segment "
					+ segment + ", Offset " + offset + " in ASB-Stationierung");

			OrtsReferenzStrassenSegmentUndOffsetInterface oref = new OrtsReferenzStrassenSegmentUndOffset(
					segment, offset);
			assertNotNull(oref);

			OrtsReferenzAsbStationierungInterface asbref = oref
					.ermittleOrtsReferenzAsbStationierung();

			System.out.println("Anfangsknoten: " + asbref.getAnfangsKnoten());
			System.out.println("Endknoten:     " + asbref.getEndKnoten());
			System.out.println("Stationierung: " + asbref.getStationierung());
			System.out.println("Richtung:      "
					+ asbref.getAsbStationierungsRichtung());
			
			assertEquals("6617008O", asbref.getAnfangsKnoten());
			assertEquals("6717023", asbref.getEndKnoten());
			assertEquals(1118, asbref.getStationierung());
			assertEquals(BisInterface.ASBStationierungsRichtung.IN_STATIONIERUNGSRICHTUNG, asbref.getAsbStationierungsRichtung());
	}
	
	/**
	 * .
	 * @throws BisInterfaceException 
	 */
	@Test (expected=BisInterfaceException.class)
	public void testErmittleOrtsReferenzASBausSSO_FehlerOffset() throws BisInterfaceException {
		String segment = IsisTests.konfig.getString("Segment");
			long offset = 10000;

			System.out.println("Test Referenzierungsumrechnung Segment "
					+ segment + ", Offset " + offset + " in ASB-Stationierung");

			OrtsReferenzStrassenSegmentUndOffsetInterface oref = new OrtsReferenzStrassenSegmentUndOffset(
					segment, offset);
			assertNotNull(oref);

			OrtsReferenzAsbStationierungInterface asbref = oref
					.ermittleOrtsReferenzAsbStationierung();

			System.out.println("Anfangsknoten: " + asbref.getAnfangsKnoten());
			System.out.println("Endknoten:     " + asbref.getEndKnoten());
			System.out.println("Stationierung: " + asbref.getStationierung());
			System.out.println("Richtung:      "
					+ asbref.getAsbStationierungsRichtung());
			
			assertEquals("6617008O", asbref.getAnfangsKnoten());
			assertEquals("6717023", asbref.getEndKnoten());
			assertEquals(1118, asbref.getStationierung());
			assertEquals(BisInterface.ASBStationierungsRichtung.IN_STATIONIERUNGSRICHTUNG, asbref.getAsbStationierungsRichtung());
	}

	/**
	 * .
	 */
	@Test
	public void testErmittleOrtsReferenzASBausSBK() {
		try {
			String strassenPid = IsisTests.konfig.getString("Strasse");
			long bkm = Long.parseLong(IsisTests.konfig
					.getString("Betriebskilometer"));
			int blocknummer = Integer.parseInt(IsisTests.konfig
					.getString("Blocknummer"));
			String richtung = IsisTests.konfig.getString("Fahrtrichtung");
			BisInterface.FahrtRichtung fahrtRichtung = null;
			if (richtung.equalsIgnoreCase("IN_RICHTUNG")) {
				fahrtRichtung = BisInterface.FahrtRichtung.IN_RICHTUNG;
			} else if (richtung.equalsIgnoreCase("GEGEN_RICHTUNG")) {
				fahrtRichtung = BisInterface.FahrtRichtung.GEGEN_RICHTUNG;
			} else {
				fail("Die Fahrtrichtungsangabe '" + richtung
						+ "' ist nicht zulssig");
			}

			StrasseInterface strasse = IsisTests.bisTest
					.getStrasse(strassenPid);
			assertNotNull(strasse);

			OrtsReferenzStrasseUndBetriebsKilometerInterface oref = new OrtsReferenzStrasseUndBetriebsKilometer(
					strasse, fahrtRichtung, bkm, blocknummer);

			assertNotNull(oref);

			OrtsReferenzAsbStationierungInterface asbref = oref.ermittleOrtsReferenzAsbStationierung();

			System.out.println("Anfangsknoten: " + asbref.getAnfangsKnoten());
			System.out.println("Endknoten:     " + asbref.getEndKnoten());
			System.out.println("Stationierung: " + asbref.getStationierung());
			System.out.println("Richtung:      " + asbref.getAsbStationierungsRichtung());
	
//			assertEquals("6617008O", asbref.getAnfangsKnoten());
//			assertEquals("6717023", asbref.getEndKnoten());
//			assertEquals(1118, asbref.getStationierung());
//			assertEquals(BisInterface.ASBStationierungsRichtung.IN_STATIONIERUNGSRICHTUNG, asbref.getAsbStationierungsRichtung());
		} catch (Exception e) {
			System.err.println(e.getMessage());
			fail();
		}

	}


}
