/*
 * Segment 2 (KEx),  SWE 2.BW-ISIS
 * Copyright (C) 2007 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weienfelser Strae 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.kex.isis.isis;

import static org.junit.Assert.assertEquals;
import static org.junit.Assert.assertNotNull;
import static org.junit.Assert.fail;

import org.junit.BeforeClass;
import org.junit.Test;

import de.bsvrz.kex.isis.isis.impl.OrtsReferenzStrasseUndBetriebsKilometer;
import de.bsvrz.kex.isis.isis.impl.OrtsReferenzStrassenSegmentUndOffset;

/**
 * Test Referenzierungsumrechnung Stra&szlig;e und Betriebskilometer in 
 * Str&szlig;ensegment und Offset.
 * 
 * @author BitCtrl Systems GmbH, Gieseler
 * @version $Id: $
 * 
 */

public class TestSBKinASB {

	/**
	 * Initialisiert den Testfall.
	 * 
	 * @throws Exception
	 *             bei einem Fehler.
	 */
	@BeforeClass
	public static void beforeClass() throws Exception {
		IsisTests.init();
	}

	/**
	 * .
	 */
	@Test
	public void testUmrechnung() {
		try {
			String strassenPid = IsisTests.konfig.getString("Strasse");
			long bkm = Long.parseLong(IsisTests.konfig
					.getString("Betriebskilometer"));
			int blocknummer = Integer.parseInt(IsisTests.konfig
					.getString("Blocknummer"));
			String richtung = IsisTests.konfig.getString("Fahrtrichtung");
			BisInterface.FahrtRichtung fahrtRichtung = null;
			if (richtung.equalsIgnoreCase("IN_RICHTUNG")) {
				fahrtRichtung = BisInterface.FahrtRichtung.IN_RICHTUNG;
			} else if (richtung.equalsIgnoreCase("GEGEN_RICHTUNG")) {
				fahrtRichtung = BisInterface.FahrtRichtung.GEGEN_RICHTUNG;
			} else {
				fail("Die Fahrtrichtungsangabe '" + richtung
						+ "' ist nicht zulssig");
			}

			StrasseInterface strasse = IsisTests.bisTest
					.getStrasse(strassenPid);
			assertNotNull(strasse);

			OrtsReferenzStrasseUndBetriebsKilometerInterface oref = new OrtsReferenzStrasseUndBetriebsKilometer(
					strasse, fahrtRichtung, bkm, blocknummer);

			assertNotNull(oref);

			OrtsReferenzAsbStationierungInterface asbref = oref.ermittleOrtsReferenzAsbStationierung();

			System.out.println("Anfangsknoten: " + asbref.getAnfangsKnoten());
			System.out.println("Endknoten:     " + asbref.getEndKnoten());
			System.out.println("Stationierung: " + asbref.getStationierung());
			System.out.println("Richtung:      " + asbref.getAsbStationierungsRichtung());
	
//			assertEquals("6617008O", asbref.getAnfangsKnoten());
//			assertEquals("6717023", asbref.getEndKnoten());
//			assertEquals(1118, asbref.getStationierung());
//			assertEquals(BisInterface.ASBStationierungsRichtung.IN_STATIONIERUNGSRICHTUNG, asbref.getAsbStationierungsRichtung());
		} catch (Exception e) {
			System.err.println(e.getMessage());
			fail();
		}

	}
}
