/*
 * Segment 2 (KEx),  SWE 2.BW-ISIS
 * Copyright (C) 2007 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weienfelser Strae 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.kex.isis.isis;

import static org.junit.Assert.assertNotNull;
import static org.junit.Assert.fail;

import org.junit.BeforeClass;
import org.junit.Test;

import de.bsvrz.kex.isis.isis.impl.OrtsReferenzStrassenSegmentUndOffset;

/**
 * Test Referenzierungsumrechnung Satr&szlig;ensegment und Offset in ASB.
 * 
 * @author BitCtrl Systems GmbH, Gieseler
 * @version $Id:$
 * 
 */

public class TestSSOinASB {

	/**
	 * Initialisiert den Testfall.
	 * 
	 * @throws Exception
	 *             bei einem Fehler.
	 */
	@BeforeClass
	public static void beforeClass() throws Exception {
		IsisTests.init();
	}

	/**
	 * .
	 */
	@Test
	public void testUmrechnung() {
		try {
			String segment = IsisTests.konfig.getString("Segment");
			long offset = Long.parseLong(IsisTests.konfig.getString("Offset"));

			System.out.println("Test Referenzierungsumrechnung Segment "
					+ segment + ", Offset " + offset + " in ASB-Stationierung");

			OrtsReferenzStrassenSegmentUndOffsetInterface oref = new OrtsReferenzStrassenSegmentUndOffset(
					segment, offset);
			assertNotNull(oref);

			OrtsReferenzAsbStationierungInterface asbref = oref
					.ermittleOrtsReferenzAsbStationierung();

			System.out.println("Anfangsknoten: " + asbref.getAnfangsKnoten());
			System.out.println("Endknoten:     " + asbref.getEndKnoten());
			System.out.println("Stationierung: " + asbref.getStationierung());
			System.out.println("Richtung:      "
					+ asbref.getAsbStationierungsRichtung());

		} catch (Exception e) {
			System.err.println(e.getMessage());
			fail();
		}

	}
}
