/*
 * Segment 2 (KEx),  SWE 2.BW-ISIS
 * Copyright (C) 2007 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weienfelser Strae 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.kex.isis.isis;

import static org.junit.Assert.assertNotNull;
import static org.junit.Assert.fail;

import org.junit.BeforeClass;
import org.junit.Test;

import de.bsvrz.kex.isis.isis.BisInterface.BaustellenZustand;

/**
 * Testfall Baustellen anlegen.
 * 
 * @author BitCtrl Systems GmbH, Gieseler
 * @version $Id: TestStackTrace.java 10544 2008-07-17 11:23:28Z gieseler $
 * 
 */

public class TestStackTrace {

	/**
	 * Initialisiert den Testfall.
	 * 
	 * @throws Exception
	 *             bei einem Fehler.
	 */
	@BeforeClass
	public static void beforeClass() throws Exception {
		IsisTests.init();
	}

	/**
	 * .
	 * 
	 * @throws java.lang.Exception
	 *             bei Ausnahmen
	 */
	@BeforeClass
	public static void setUpBeforeClass() throws Exception {
		System.out.println("BW-ISIS-Prfungen, Prffall 3");
	}

	/**
	 * Test method for
	 * {@link de.bsvrz.kex.isis.isis.impl.AbstractBIS#erzeugeBaustelle(java.lang.String, java.lang.String, java.lang.String, long, long, de.bsvrz.kex.isis.isis.OrtsReferenzStrassenSegmentUndOffsetInterface, long, de.bsvrz.kex.isis.isis.BisInterface.BaustellenZustand, int, de.bsvrz.kex.isis.isis.BaustellenVerantwortlicherInterface)}.
	 */
	@Test
	public void testBaustelleAnlegen() {
		try {
			String baustellenverantwortlichername = "TestBaustellenVerantwortlicher";

			BaustellenVerantwortlicherInterface v = IsisTests.bisTest
					.erzeugeBaustellenVerantwortlichen(
							baustellenverantwortlichername + " firma",
							null,
							// baustellenverantwortlichername + " name",
							baustellenverantwortlichername + " telefon",
							baustellenverantwortlichername + " telefonFirma",
							baustellenverantwortlichername + " telefonMobil");

			// 2926.80
			OrtsReferenzStrassenSegmentUndOffsetInterface oref = IsisTests.bisTest
					.erzeugeOrtsReferenz(IsisTests.konfig
							.getString("AnlegenSegment"), Long
							.parseLong(IsisTests.konfig
									.getString("AnlegenOffset")));

			assertNotNull(oref);

			System.out.println();

			System.out.println("Eine Baustelle wird angelegt");
			long baustelleid = IsisTests.bisTest.erzeugeBaustelle(null, null,
					null, 1, 0, oref, 0, BaustellenZustand.ENTWORFEN, 0, v);
			System.out.println("Die Baustelle '"
					+ IsisTests.bisTest.getBaustelle(baustelleid).getPid()
					+ "' wurde angelegt");

		} catch (BisInterfaceException e) {
			System.err.println(e);
			e.printStackTrace();
			fail();
		}

	}
}
