/*
 * Segment 2 (KEx),  SWE 2.BW-ISIS
 * Copyright (C) 2007 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weienfelser Strae 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.kex.isis.isis;

import static org.junit.Assert.assertEquals;
import static org.junit.Assert.assertNotNull;
import static org.junit.Assert.fail;

import java.io.File;

import org.junit.Before;
import org.junit.Test;

import de.bsvrz.kex.isis.isis.impl.AbstractBIS;

/**
 * Testcase Stra&szlig;en.
 * 
 * @author BitCtrl Systems GmbH, Gieseler
 * @version $Id: TestStrassen.java 7381 2008-03-12 16:20:54Z gieseler $
 * 
 */

public class TestStrassen extends AbstractBIS {
	/**
	 * BIS-Interface initialisieren.
	 * 
	 * @throws java.lang.Exception
	 *             bei Ausnahmen
	 */
	@Before
	public void setUp() throws Exception {
		final String propfilename = "de/bsvrz/kex/isis/isis.properties";
		try {
			File propfile = new File(ClassLoader
					.getSystemResource(propfilename).getFile());
			this.init(propfile.getAbsolutePath());
		} catch (BisInterfaceException e) {
			fail(e.getMessage());
		}
	}

	/**
	 * Test method for
	 * {@link de.bsvrz.kex.isis.isis.impl.AbstractBIS#loescheBaustelle(long)}.
	 */
	@Test
	public void testeStrassen() {
		String strassepid = "strasse.A.5.tmclc.07128";

		StrasseInterface si;
		try {
			si = getStrasse(strassepid);
			assertNotNull(si);
			StrasseInterface[] strassen = getStrassen(1, 5, "");
			assertEquals(strassen.length, 3);
		} catch (BisInterfaceException e) {
			fail(e.getMessage());
		}
	}
}
