package de.bsvrz.kex.isis.isis;


import static org.junit.Assert.assertNotNull;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Collection;
import java.util.GregorianCalendar;
import java.util.List;

import org.junit.After;
import org.junit.AfterClass;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

import de.bsvrz.dav.daf.main.ClientDavConnection;
import de.bsvrz.dav.daf.main.ClientDavInterface;
import de.bsvrz.dav.daf.main.ClientDavParameters;
import de.bsvrz.dav.daf.main.config.DataModel;
import de.bsvrz.dav.daf.main.config.SystemObject;
import de.bsvrz.kex.isis.isis.BisInterface.BaustellenZustand;
import de.bsvrz.kex.isis.isis.impl.AbstractBIS;
import de.bsvrz.kex.isis.isis.impl.MessQuerschnitt;
import de.bsvrz.kex.isis.isis.impl.OrtsReferenzAsbStationierung;
import de.bsvrz.kex.isis.isis.impl.OrtsReferenzStrassenSegmentUndOffset;
import de.bsvrz.sys.funclib.bitctrl.modell.ObjektFactory;
import de.bsvrz.sys.funclib.bitctrl.modell.verkehr.VerkehrsobjektFactory;
import de.bsvrz.sys.funclib.bitctrl.modell.verkehr.objekte.MessQuerschnittAllgemein;
import de.bsvrz.sys.funclib.bitctrl.modell.verkehr.objekte.StrassenSegment;
import de.bsvrz.sys.funclib.bitctrl.modell.verkehr.objekte.VerkehrModellNetz;
import de.bsvrz.sys.funclib.commandLineArgs.ArgumentList;
import de.bsvrz.sys.funclib.debug.Debug;

/**
 * @author BitCtrl Systems GmbH, Gieseler
 * @version $Id: TesteASB_nach_SegmentOffset.java 6857 2008-02-21 16:43:11Z gieseler $
 *
 */

public class TesteASB_nach_SegmentOffset extends AbstractBIS {

	/**
	 * @throws java.lang.Exception
	 */
	@BeforeClass
	public static void setUpBeforeClass() throws Exception {
	}

	/**
	 * @throws java.lang.Exception
	 */
	@AfterClass
	public static void tearDownAfterClass() throws Exception {
	}

	/**
	 * @throws java.lang.Exception
	 */
	@Before
	public void setUp() throws Exception {
	}

	/**
	 * @throws java.lang.Exception
	 */
	@After
	public void tearDown() throws Exception {
	}

	/**
	 * Test method for {@link de.bsvrz.kex.isis.isis.impl.AbstractBIS#erzeugeBaustelle(java.lang.String, java.lang.String, java.lang.String, long, long, de.bsvrz.kex.isis.isis.OrtsReferenzStrassenSegmentUndOffsetInterface, long, de.bsvrz.kex.isis.isis.BisInterface.BaustellenZustand, int, de.bsvrz.kex.isis.isis.BaustellenVerantwortlicherInterface)}.
	 */
	@Test
	public void TestSegmentOffset_nach_ASB() {
		final String propfilename = "de/bsvrz/kex/isis/isis.properties";
		try {
			File propfile =  new File(
					ClassLoader.getSystemResource(propfilename).getFile());
			this.init(propfile.getAbsolutePath());
			
			String Anfangsknoten="8211024";
			String Endknoten="8311029";
			long Stationierung=2000;
			ASBStationierungsRichtung richtung = ASBStationierungsRichtung.GEGEN_STATIONIERUNGSRICHTUNG;
			
			OrtsReferenzAsbStationierung asbref = new OrtsReferenzAsbStationierung(
					Anfangsknoten, Endknoten, richtung, Stationierung);
			
			// 2926.80
//			OrtsReferenzStrassenSegmentUndOffsetInterface oref = erzeugeOrtsReferenz(
//					"ass.n.11607.n.11606.0", 2926); 

			assertNotNull(asbref);

			List<OrtsReferenzStrassenSegmentUndOffsetInterface> soref = asbref.ermittleOrtsReferenzStrassenSegmentUndOffset();
			
			assertNotNull(soref);
			
			for(OrtsReferenzStrassenSegmentUndOffsetInterface ref : soref) {
				System.out.println("Ortsreferenz:");
				System.out.println("Segment: " + ref.getStrassenSegment().getPid() + " Offset: " + ref.getStartOffset());
			}
			
			richtung = ASBStationierungsRichtung.IN_STATIONIERUNGSRICHTUNG;
			
			asbref = new OrtsReferenzAsbStationierung(
					Anfangsknoten, Endknoten, richtung, Stationierung);
			
			// 2926.80
//			OrtsReferenzStrassenSegmentUndOffsetInterface oref = erzeugeOrtsReferenz(
//					"ass.n.11607.n.11606.0", 2926); 

			assertNotNull(asbref);

			soref = asbref.ermittleOrtsReferenzStrassenSegmentUndOffset();
			
			assertNotNull(soref);
			
			for(OrtsReferenzStrassenSegmentUndOffsetInterface ref : soref) {
				System.out.println("Ortsreferenz:");
				System.out.println("Segment: " + ref.getStrassenSegment().getPid() + " Offset: " + ref.getStartOffset());
			}
			
		} catch (FileNotFoundException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		} catch (IOException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		} catch (BisInterfaceException e) {
			System.err.println(e.getMessage());
		}
		
	}
}
