/**
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 2 of the License, or (at your option) any later
 * version.
 * 
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 * 
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 51
 * Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 * 
 * Contact Information:<br>
 * BitCtrl Systems GmbH<br>
 * Wei&szlig;enfelser Stra&szlig;e 67<br>
 * 04229 Leipzig<br>
 * Phone: +49 341-490670<br>
 * mailto: info@bitctrl.de
 */

package de.bsvrz.kex.isis.isis;

import static org.junit.Assert.assertNotNull;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Collection;
import java.util.GregorianCalendar;

import org.junit.After;
import org.junit.AfterClass;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

import de.bsvrz.dav.daf.main.ClientDavConnection;
import de.bsvrz.dav.daf.main.ClientDavInterface;
import de.bsvrz.dav.daf.main.ClientDavParameters;
import de.bsvrz.dav.daf.main.config.DataModel;
import de.bsvrz.dav.daf.main.config.SystemObject;
import de.bsvrz.kex.isis.isis.BisInterface.BaustellenZustand;
import de.bsvrz.kex.isis.isis.impl.AbstractBIS;
import de.bsvrz.kex.isis.isis.impl.MessQuerschnitt;
import de.bsvrz.kex.isis.isis.impl.OrtsReferenzStrassenSegmentUndOffset;
import de.bsvrz.sys.funclib.bitctrl.modell.ObjektFactory;
import de.bsvrz.sys.funclib.bitctrl.modell.verkehr.VerkehrsobjektFactory;
import de.bsvrz.sys.funclib.bitctrl.modell.verkehr.objekte.MessQuerschnittAllgemein;
import de.bsvrz.sys.funclib.bitctrl.modell.verkehr.objekte.StrassenSegment;
import de.bsvrz.sys.funclib.bitctrl.modell.verkehr.objekte.VerkehrModellNetz;
import de.bsvrz.sys.funclib.commandLineArgs.ArgumentList;
import de.bsvrz.sys.funclib.debug.Debug;

/**
 * @author BitCtrl Systems GmbH, Gieseler
 * @version $Id: TesteBaustelleAnlegen.java 6917 2008-02-22 16:18:48Z gieseler $
 *
 */

public class TesteBaustelleAnlegen extends AbstractBIS {

	/**
	 * @throws java.lang.Exception
	 */
	@BeforeClass
	public static void setUpBeforeClass() throws Exception {
	}

	/**
	 * @throws java.lang.Exception
	 */
	@AfterClass
	public static void tearDownAfterClass() throws Exception {
	}

	/**
	 * @throws java.lang.Exception
	 */
	@Before
	public void setUp() throws Exception {
	}

	/**
	 * @throws java.lang.Exception
	 */
	@After
	public void tearDown() throws Exception {
	}

	/**
	 * Test method for {@link de.bsvrz.kex.isis.isis.impl.AbstractBIS#erzeugeBaustelle(java.lang.String, java.lang.String, java.lang.String, long, long, de.bsvrz.kex.isis.isis.OrtsReferenzStrassenSegmentUndOffsetInterface, long, de.bsvrz.kex.isis.isis.BisInterface.BaustellenZustand, int, de.bsvrz.kex.isis.isis.BaustellenVerantwortlicherInterface)}.
	 */
	@Test
	public void TestBaustelleAnlegen() {
		final String propfilename = "de/bsvrz/kex/isis/isis.properties";
		try {
			File propfile =  new File(
					ClassLoader.getSystemResource(propfilename).getFile());
			this.init(propfile.getAbsolutePath());
			BaustellenVerantwortlicherInterface v = erzeugeBaustellenVerantwortlichen(
					"firma", 
					"verantwortlicher", 
					"tel",
					"telf", 
					"telmob");
			String bpid="bpid."+System.currentTimeMillis();
			System.out.println("PID:  " + bpid);
			
			// 2926.80
			OrtsReferenzStrassenSegmentUndOffsetInterface oref = erzeugeOrtsReferenz(
					"iss.n.11607.n.11606.0", 462); 

			assertNotNull(oref);

			long bid  = erzeugeBaustelle(bpid, "TestbaustelleMitDaten", null, 
					System.currentTimeMillis(), 10000, oref, 1100, BaustellenZustand.GUELTIG, 200, v);
			
		} catch (FileNotFoundException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		} catch (IOException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		} catch (BisInterfaceException e) {
			System.err.println(e.getMessage());
		}
		
	}
}
