/**
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 2 of the License, or (at your option) any later
 * version.
 * 
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 * 
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 51
 * Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 * 
 * Contact Information:<br>
 * BitCtrl Systems GmbH<br>
 * Wei&szlig;enfelser Stra&szlig;e 67<br>
 * 04229 Leipzig<br>
 * Phone: +49 341-490670<br>
 * mailto: info@bitctrl.de
 */

package de.bsvrz.kex.isis.isis;

import static org.junit.Assert.assertNotNull;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;

import org.junit.After;
import org.junit.AfterClass;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

import de.bsvrz.dav.daf.main.DataNotSubscribedException;
import de.bsvrz.kex.isis.isis.impl.AbstractBIS;

/**
 * @author BitCtrl Systems GmbH, Gieseler
 * @version $Id: TesteBaustellenEreignisse.java 6917 2008-02-22 16:18:48Z
 *          gieseler $
 * 
 */

public class TesteBaustellenEreignisse extends AbstractBIS {

	/**
	 * @throws java.lang.Exception
	 */
	@BeforeClass
	public static void setUpBeforeClass() throws Exception {
	}

	/**
	 * @throws java.lang.Exception
	 */
	@AfterClass
	public static void tearDownAfterClass() throws Exception {
	}

	/**
	 * @throws java.lang.Exception
	 */
	@Before
	public void setUp() throws Exception {
	}

	/**
	 * @throws java.lang.Exception
	 */
	@After
	public void tearDown() throws Exception {
	}

	/**
	 * Test method for
	 * {@link de.bsvrz.kex.isis.isis.impl.AbstractBIS#erzeugeBaustelle(java.lang.String, java.lang.String, java.lang.String, long, long, de.bsvrz.kex.isis.isis.OrtsReferenzStrassenSegmentUndOffsetInterface, long, de.bsvrz.kex.isis.isis.BisInterface.BaustellenZustand, int, de.bsvrz.kex.isis.isis.BaustellenVerantwortlicherInterface)}.
	 */
	@Test
	public void TestBaustellenEreignisse() {
		final String propfilename = "de/bsvrz/kex/isis/isis.properties";
		try {
			File propfile = new File(ClassLoader
					.getSystemResource(propfilename).getFile());
			this.init(propfile.getAbsolutePath());
			BaustellenVerantwortlicherInterface v = erzeugeBaustellenVerantwortlichen(
					"firma", "verantwortlicher", "tel", "telf", "telmob");
			String bpid = "bpid." + System.currentTimeMillis();
			System.out.println("PID:  " + bpid);

			// 2926.80
			OrtsReferenzStrassenSegmentUndOffsetInterface oref = erzeugeOrtsReferenz(
					"ass.n.11607.n.11606.0", 2926);

			assertNotNull(oref);

			long bid = erzeugeBaustelle(bpid, "TestbaustelleEreignisse", null,
					System.currentTimeMillis() + 60 * 60 * 1000, 0, oref, 1000,
					BaustellenZustand.ENTWORFEN, 0, v);

			BaustelleInterface bi = getBaustelle(bid);

			Thread.sleep(10000);
			System.out.println("neuer Zustand: "
					+ BisInterface.BaustellenZustand.GEPLANT);
			bi.aendereBaustellenZustand(BisInterface.BaustellenZustand.GEPLANT);

			Thread.sleep(10000);
			System.out.println("neuer Zustand: "
					+ BisInterface.BaustellenZustand.GUELTIG);
			bi.aendereBaustellenZustand(BisInterface.BaustellenZustand.GUELTIG);

			Thread.sleep(10000);
			System.out.println("neuer Zustand: "
					+ BisInterface.BaustellenZustand.STORNIERT);
			bi
					.aendereBaustellenZustand(BisInterface.BaustellenZustand.STORNIERT);

		} catch (FileNotFoundException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		} catch (IOException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		} catch (BisInterfaceException e) {
			System.err.println(e.getMessage());
		} catch (InterruptedException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		} catch (DataNotSubscribedException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
			// } catch (SendSubscriptionNotConfirmed e) {
			// // TODO Auto-generated catch block
			// e.printStackTrace();
		}

	}
}
