package de.bsvrz.kex.isis.isis;


import static org.junit.Assert.assertNotNull;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;

import org.junit.After;
import org.junit.AfterClass;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

import de.bsvrz.kex.isis.isis.impl.AbstractBIS;

/**
 * Testcase f&uuml;r die Kommunikations&uuml;berwachung zum Datenverteiler.
 * 
 * @author BitCtrl Systems GmbH, Gieseler
 * @version $Id: TesteDavKommunikation.java 6857 2008-02-21 16:43:11Z gieseler $
 *
 */

public class TesteDavKommunikation extends AbstractBIS implements BisKommunikationsStatusListener {

	/**
	 * @throws java.lang.Exception
	 */
	@BeforeClass
	public static void setUpBeforeClass() throws Exception {
	}

	/**
	 * @throws java.lang.Exception
	 */
	@AfterClass
	public static void tearDownAfterClass() throws Exception {
	}

	/**
	 * @throws java.lang.Exception
	 */
	@Before
	public void setUp() throws Exception {
	}

	/**
	 * @throws java.lang.Exception
	 */
	@After
	public void tearDown() throws Exception {
	}

	/**
	 * 
	 */
	@Test
	public void TestDavKommunikation() {
		final String propfilename = "de/bsvrz/kex/isis/isis.properties";
		try {
			File propfile =  new File(
					ClassLoader.getSystemResource(propfilename).getFile());
			this.init(propfile.getAbsolutePath());
			
			System.out.println("Datenverteilerverbindung initialisiert");
			
			addKommunikationsStatusListener(this);
	
			System.out.println("Warte auf Statusnderung Datenverteilerverbindung");
			while(true) {
				try {
					Thread.sleep(1000);
				} catch (InterruptedException e) {
					/** */
				}
			}
		} catch (FileNotFoundException e) {
			e.printStackTrace();
		} catch (IOException e) {
			// TODO Auto-generated catch block
		} catch (BisInterfaceException e) {
			System.err.println(e.getMessage());
		} catch (Exception e) {
			e.printStackTrace();
		}
	}

	/* (non-Javadoc)
	 * @see de.bsvrz.kex.isis.isis.BisKommunikationsStatusListener#setKommunikationsStatus(de.bsvrz.kex.isis.isis.BisInterface.BisKommunikationsStatus)
	 */
	public void setKommunikationsStatus(
			BisKommunikationsStatus bisKommunikationsStatus) {
		System.out.println("neuer Kommunikationsstatus: " + bisKommunikationsStatus);
	}
}
