package de.bsvrz.kex.isis.isis;


import static org.junit.Assert.*;
import static org.junit.Assert.assertNotNull;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Collection;
import java.util.GregorianCalendar;
import java.util.List;

import org.junit.After;
import org.junit.AfterClass;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

import de.bsvrz.dav.daf.main.ClientDavConnection;
import de.bsvrz.dav.daf.main.ClientDavInterface;
import de.bsvrz.dav.daf.main.ClientDavParameters;
import de.bsvrz.dav.daf.main.config.DataModel;
import de.bsvrz.dav.daf.main.config.SystemObject;
import de.bsvrz.kex.isis.isis.BisInterface.BaustellenZustand;
import de.bsvrz.kex.isis.isis.impl.AbstractBIS;
import de.bsvrz.kex.isis.isis.impl.MessQuerschnitt;
import de.bsvrz.kex.isis.isis.impl.OrtsReferenzStrassenSegmentUndOffset;
import de.bsvrz.sys.funclib.bitctrl.modell.ObjektFactory;
import de.bsvrz.sys.funclib.bitctrl.modell.verkehr.VerkehrsobjektFactory;
import de.bsvrz.sys.funclib.bitctrl.modell.verkehr.objekte.MessQuerschnittAllgemein;
import de.bsvrz.sys.funclib.bitctrl.modell.verkehr.objekte.StrassenSegment;
import de.bsvrz.sys.funclib.bitctrl.modell.verkehr.objekte.VerkehrModellNetz;
import de.bsvrz.sys.funclib.commandLineArgs.ArgumentList;
import de.bsvrz.sys.funclib.debug.Debug;

/**
 * @author BitCtrl Systems GmbH, Gieseler
 * @version $Id: TesteSegmentOffset_nach_ASB.java 6917 2008-02-22 16:18:48Z gieseler $
 *
 */

public class TesteSegmentOffset_nach_ASB extends AbstractBIS {

	/**
	 * @throws java.lang.Exception
	 */
	@BeforeClass
	public static void setUpBeforeClass() throws Exception {
	}

	/**
	 * @throws java.lang.Exception
	 */
	@AfterClass
	public static void tearDownAfterClass() throws Exception {
	}

	/**
	 * @throws java.lang.Exception
	 */
	@Before
	public void setUp() throws Exception {
	}

	/**
	 * @throws java.lang.Exception
	 */
	@After
	public void tearDown() throws Exception {
	}

	/**
	 * Test method for {@link de.bsvrz.kex.isis.isis.impl.AbstractBIS#erzeugeBaustelle(java.lang.String, java.lang.String, java.lang.String, long, long, de.bsvrz.kex.isis.isis.OrtsReferenzStrassenSegmentUndOffsetInterface, long, de.bsvrz.kex.isis.isis.BisInterface.BaustellenZustand, int, de.bsvrz.kex.isis.isis.BaustellenVerantwortlicherInterface)}.
	 */
	@Test
	public void TestSegmentOffset_nach_ASB() {
		final String propfilename = "de/bsvrz/kex/isis/isis.properties";
		try {
			File propfile =  new File(
					ClassLoader.getSystemResource(propfilename).getFile());
			this.init(propfile.getAbsolutePath());
			
			// ass.n.11607.n.11606.0
			// Lnge: 2926.80
			// sts.17242.BW
			// StrassenelementInASS.090007njng
			// vNK 6417028
			// nNK 6517065
			// ASB-Anfang 256
			// ASB-Ende 3186

			String segment = "ass.n.11607.n.11606.0";
			long offset = 2926;
			
			System.out.println("Teste Segment: " + segment + ", Offset: " + offset);
			OrtsReferenzStrassenSegmentUndOffsetInterface oref = erzeugeOrtsReferenz(
					segment, offset); 

			assertNotNull(oref);
			
			//assertEquals(0, oref.getLaengsNeigung());

			OrtsReferenzAsbStationierungInterface asb = oref.ermittleOrtsReferenzAsbStationierung();
			System.out.println("ASB-Stationierung:");
			System.out.println("Anfangsknoten: " + asb.getAnfangsKnoten() + " Endknoten: " + asb.getEndKnoten());
			System.out.println("Stationierung: " + asb.getStationierung() + " Verkehrsrichtung: " + asb.getAsbStationierungsRichtung());
			
			assertEquals("6417028", asb.getAnfangsKnoten());
			assertEquals("6517065", asb.getEndKnoten());

			OrtsReferenzStrasseUndBetriebsKilometerInterface sbk = oref.ermittleOrtsReferenzStrasseUndBetriebsKilometer();
			System.out.println("Strae-und-Betriebskilometer-Stationierung:");
			System.out.println("Strasse: " + sbk.getStrasse().getName() + " Betriebskilometer: " + sbk.getBetriebsKilometer());
			System.out.println("Blocknummer: " + sbk.getBlockNummer() + " Fahrtrichtung: " + sbk.getFahrtRichtung());
			
			System.out.println("ASB-Stationierung:");
			System.out.println("Anfangsknoten: " + asb.getAnfangsKnoten() + " Endknoten: " + asb.getEndKnoten());
			System.out.println("Stationierung: " + asb.getStationierung() + " Verkehrsrichtung: " + asb.getAsbStationierungsRichtung());

			// und zurck
			List<OrtsReferenzStrassenSegmentUndOffsetInterface> soref = asb.ermittleOrtsReferenzStrassenSegmentUndOffset();
			for(OrtsReferenzStrassenSegmentUndOffsetInterface sorefi : soref) {
				System.out.println("Strassensegment: " + sorefi.getStrassenSegment().getPid() +  ", Offset: " + sorefi.getStartOffset());
			}
			
		} catch (FileNotFoundException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		} catch (IOException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		} catch (BisInterfaceException e) {
			System.err.println(e.getMessage());
		}
		
	}
}
