/*
 * Decompiled with CFR 0.152.
 */
package de.bsvrz.kex.tls.deabruf;

import de.bsvrz.dav.daf.main.ClientDavInterface;
import de.bsvrz.dav.daf.main.ClientSenderInterface;
import de.bsvrz.dav.daf.main.Data;
import de.bsvrz.dav.daf.main.DataDescription;
import de.bsvrz.dav.daf.main.OneSubscriptionPerSendData;
import de.bsvrz.dav.daf.main.ResultData;
import de.bsvrz.dav.daf.main.SenderRole;
import de.bsvrz.dav.daf.main.config.Aspect;
import de.bsvrz.dav.daf.main.config.AttributeGroup;
import de.bsvrz.dav.daf.main.config.DataModel;
import de.bsvrz.dav.daf.main.config.SystemObject;
import de.bsvrz.sys.funclib.debug.Debug;
import java.text.SimpleDateFormat;
import java.util.Date;

public class Auftrag
implements ClientSenderInterface {
    private static final String ASPEKT = "asp.tlsAbruf";
    private static final String ATG = "atg.tlsGloDeBlockAbruf";
    private static final Debug debug = Debug.getLogger();
    private static SimpleDateFormat DATUM_FORMATIERER = new SimpleDateFormat("dd.MM.yyyy HH:mm:ss,SSS");
    private static ClientDavInterface _dav;
    private static DataModel _davKonf;
    private long _ausfuehrungsZeitPunkt = 0L;
    private boolean _sendeErlaubnis = false;
    private boolean _aktiviert;
    private String _dePid;
    private int _id;
    private int _typ;
    private long _zeitIntervallInMillis;

    public Auftrag(ClientDavInterface clientDavInterface, String string, int n, int n2, long l, long l2, boolean bl) {
        _dav = clientDavInterface;
        _davKonf = _dav.getDataModel();
        this._dePid = string;
        this._id = n;
        this._typ = n2;
        this._ausfuehrungsZeitPunkt = l;
        this._zeitIntervallInMillis = l2;
        this._aktiviert = bl;
    }

    public boolean ausfuehren() {
        if (!this._aktiviert) {
            debug.info(String.format("Der Auftrag ist nicht aktiviert: %s", this));
            return false;
        }
        SystemObject systemObject = _davKonf.getObject(this._dePid);
        AttributeGroup attributeGroup = _davKonf.getAttributeGroup(ATG);
        Aspect aspect = _davKonf.getAspect(ASPEKT);
        DataDescription dataDescription = new DataDescription(attributeGroup, aspect);
        try {
            _dav.subscribeSender((ClientSenderInterface)this, systemObject, dataDescription, SenderRole.sender());
        }
        catch (OneSubscriptionPerSendData oneSubscriptionPerSendData) {
            debug.warning(String.format("Datenidentifikation ist bereits angemeldet. Eventuell Senke nicht vorhanden: <%s>, <%s>", systemObject, dataDescription), (Throwable)oneSubscriptionPerSendData);
            return false;
        }
        catch (Exception exception) {
            debug.warning(String.format("Fehler bei der Anmeldung der Daten als Sender: <%s>, <%s>", systemObject, dataDescription), (Throwable)exception);
            return false;
        }
        for (int i = 0; i < 10 && !this._sendeErlaubnis; ++i) {
            try {
                Thread.sleep(500L);
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        boolean bl = false;
        if (!this._sendeErlaubnis) {
            debug.warning(String.format("Sendeerlaubnis ist nicht vorhanden: <%s>, <%s>", systemObject, dataDescription));
        } else {
            Data data = _dav.createData(attributeGroup);
            data.getItem("JobNummer").asUnscaledValue().set(1);
            data.getItem("ID").asUnscaledValue().set(this._id);
            data.getItem("Typ").asUnscaledValue().set(this._typ);
            ResultData resultData = new ResultData(systemObject, dataDescription, System.currentTimeMillis(), data, false);
            try {
                _dav.sendData(resultData);
                bl = true;
            }
            catch (Exception exception) {
                debug.warning(String.format("Fehler beim Senden der Daten an DaV: <%s>, <%s>", systemObject, dataDescription), (Throwable)exception);
            }
        }
        try {
            _dav.unsubscribeSender((ClientSenderInterface)this, systemObject, dataDescription);
        }
        catch (Exception exception) {
            debug.warning(String.format("Fehler bei der Abmeldung der Daten als Sender: <%s>, <%s>", systemObject, dataDescription), (Throwable)exception);
        }
        return bl;
    }

    public void dataRequest(SystemObject systemObject, DataDescription dataDescription, byte by) {
        this._sendeErlaubnis = by == 0;
        String string = "unbekannter Status";
        if (by == 0) {
            string = "START_SENDING";
        } else if (by == 1) {
            string = "STOP_SENDING";
        } else if (by == 2) {
            string = "STOP_SENDING_NO_RIGHTS";
        } else if (by == 3) {
            string = "STOP_SENDING_NOT_A_VALID_SUBSCRIPTION";
        }
        debug.fine(String.format("SO: %s%nDatenbeschreibung: %s%nStatus: %s%n", systemObject, dataDescription, string));
    }

    public long getAusfuehrungsZeitPunkt() {
        return this._ausfuehrungsZeitPunkt;
    }

    public String getDePid() {
        return this._dePid;
    }

    public int getId() {
        return this._id;
    }

    public int getTyp() {
        return this._typ;
    }

    private static String getZeitdauerAlsString(long l) {
        long l2 = l / 3600000L;
        long l3 = (l - l2 * 60L * 60L * 1000L) / 60000L;
        float f = (float)(l - l2 * 60L * 60L * 1000L - l3 * 60L * 1000L) / 1000.0f;
        return String.format("%02d:%02d:%02d", l2, l3, Math.round(f));
    }

    public long getZeitIntervallInMillis() {
        return this._zeitIntervallInMillis;
    }

    public boolean isAktiviert() {
        return this._aktiviert;
    }

    public boolean isRequestSupported(SystemObject systemObject, DataDescription dataDescription) {
        return true;
    }

    public boolean istAelterAls(Auftrag auftrag) {
        boolean bl;
        boolean bl2 = bl = this._id == auftrag._id && this._typ == auftrag._typ && this._dePid.equals(auftrag._dePid);
        return bl && this._ausfuehrungsZeitPunkt < auftrag._ausfuehrungsZeitPunkt;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Auftrag");
        stringBuilder.append("{_ausfuehrungsZeitPunkt=").append(DATUM_FORMATIERER.format(new Date(this._ausfuehrungsZeitPunkt)));
        stringBuilder.append(", _dePid=").append(this._dePid);
        stringBuilder.append(", _id=").append(this._id);
        stringBuilder.append(", _typ=").append(this._typ);
        stringBuilder.append(", _zeitIntervallInMillis='").append(Auftrag.getZeitdauerAlsString(this._zeitIntervallInMillis)).append('\'');
        stringBuilder.append(", _aktiviert=").append(this._aktiviert ? "ja" : "nein");
        stringBuilder.append('}');
        return stringBuilder.toString();
    }
}

