/*
 * Decompiled with CFR 0.152.
 */
package de.bsvrz.kex.tls.deabruf;

import de.bsvrz.dav.daf.main.ClientDavInterface;
import de.bsvrz.dav.daf.main.ClientReceiverInterface;
import de.bsvrz.dav.daf.main.Data;
import de.bsvrz.dav.daf.main.DataDescription;
import de.bsvrz.dav.daf.main.ReceiveOptions;
import de.bsvrz.dav.daf.main.ReceiverRole;
import de.bsvrz.dav.daf.main.ResultData;
import de.bsvrz.dav.daf.main.config.Aspect;
import de.bsvrz.dav.daf.main.config.AttributeGroup;
import de.bsvrz.dav.daf.main.config.DataModel;
import de.bsvrz.dav.daf.main.config.SystemObject;
import de.bsvrz.kex.tls.deabruf.Auftrag;
import de.bsvrz.kex.tls.deabruf.AuftragsListe;
import de.bsvrz.sys.funclib.application.StandardApplication;
import de.bsvrz.sys.funclib.application.StandardApplicationRunner;
import de.bsvrz.sys.funclib.commandLineArgs.ArgumentList;
import de.bsvrz.sys.funclib.debug.Debug;

public class DeAbruf
implements StandardApplication,
ClientReceiverInterface {
    private static final String ASPEKT = "asp.parameterSoll";
    private static final String ATG = "atg.paramTlsDeAbruf";
    private static Debug debug = Debug.getLogger();
    private static DataDescription datenBeschreibung;
    private ClientDavInterface _dav;
    private DataModel _davKonf;
    private int _parPauseInSekunden;
    private String _parSoPid;
    private long _pauseInMillis;

    private void addAuftrag(String string, int n, int n2, long l, long l2, boolean bl) {
        if (!bl) {
            return;
        }
        if (l2 > 0L) {
            Auftrag auftrag = new Auftrag(this._dav, string, n, n2, l, l2, bl);
            AuftragsListe.getInstanz().addAuftrag(auftrag);
            debug.info(String.format("Eingef\u00fcgter Auftrag: %s", auftrag));
        }
    }

    public void initialize(ClientDavInterface clientDavInterface) throws Exception {
        this._dav = clientDavInterface;
        this._davKonf = this._dav.getDataModel();
        SystemObject systemObject = this._davKonf.getObject(this._parSoPid);
        if (systemObject == null) {
            debug.error(String.format("Das Objekte mit dem PID <%s> kann nicht ermittelt werden!. Bitte pr\u00fcfen Sie den Aufrufparameter <-soDeAbrufPid>. Programm wird beendet.", this._parSoPid));
            throw new RuntimeException("Null-Objekt");
        }
        AttributeGroup attributeGroup = this._davKonf.getAttributeGroup(ATG);
        Aspect aspect = this._davKonf.getAspect(ASPEKT);
        datenBeschreibung = new DataDescription(attributeGroup, aspect);
        try {
            this._dav.subscribeReceiver((ClientReceiverInterface)this, systemObject, datenBeschreibung, new ReceiveOptions(false), ReceiverRole.receiver());
        }
        catch (Exception exception) {
            debug.error(String.format("Fehler bei der Anmeldung der Daten als Empf\u00e4nger: <%s>, <%s>", systemObject, datenBeschreibung), (Throwable)exception);
            throw new RuntimeException(exception);
        }
    }

    public static void main(String[] stringArray) {
        DeAbruf deAbruf = new DeAbruf();
        StandardApplicationRunner.run((StandardApplication)deAbruf, (String[])stringArray);
        debug = Debug.getLogger();
        deAbruf.starteProzess();
    }

    public void parseArguments(ArgumentList argumentList) throws Exception {
        String string = "-soDeAbrufPid";
        try {
            this._parSoPid = argumentList.fetchArgument(string).asNonEmptyString();
        }
        catch (Exception exception) {
            debug.error(String.format("Bitte die SystemObjekt-PID f\u00fcr den DE-Abruf als Parameter <%s> \u00fcbergeben!", string), (Throwable)exception);
            throw new RuntimeException(exception);
        }
        string = "-ueberwachungsZeitInSekunden";
        try {
            this._parPauseInSekunden = argumentList.fetchArgument(string).intValue();
            this._pauseInMillis = this._parPauseInSekunden * 1000;
        }
        catch (Exception exception) {
            debug.error(String.format("Bitte die Pause in Sekunden f\u00fcr die DE-Abruf-\u00dcberwachung als Parameter <%s> \u00fcbergeben!", string), (Throwable)exception);
            throw new RuntimeException(exception);
        }
    }

    private void starteProzess() {
        debug.info(String.format("%n=================================================================%nDE-Abruf gestartet...%n=================================================================%n", new Object[0]));
        while (true) {
            Auftrag auftrag;
            if ((auftrag = AuftragsListe.getInstanz().holeNaechstenAuftrag()) != null) {
                long l = System.currentTimeMillis() + auftrag.getZeitIntervallInMillis();
                this.addAuftrag(auftrag.getDePid(), auftrag.getId(), auftrag.getTyp(), l, auftrag.getZeitIntervallInMillis(), auftrag.isAktiviert());
                if (auftrag.ausfuehren()) {
                    debug.info(String.format("Ausgef\u00fchrter Auftrag: %s", auftrag));
                    continue;
                }
                debug.warning(String.format("Folgender Auftrag wurde nicht ausgef\u00fchrt: %s%n(siehe Meldungen oben)", auftrag));
                continue;
            }
            debug.fine(String.format("Zur Zeit keine sofort auszuf\u00fchrenden Auftr\u00e4ge in der Auftragsliste. Warte %d Sekunden.", this._parPauseInSekunden));
            try {
                Thread.sleep(this._pauseInMillis);
                continue;
            }
            catch (InterruptedException interruptedException) {
                debug.info("Sleep der Auftragsbearbeitung des DE-Abrufs wurde vorzeitig unterbrochen: ", (Throwable)interruptedException);
                continue;
            }
            break;
        }
    }

    public void update(ResultData[] resultDataArray) {
        debug.info(String.format("%n=================================================================%nErstelle die Liste der Auftrage aus DaV-Daten neu...%n=================================================================%n", new Object[0]));
        AuftragsListe.getInstanz().loescheAlleAuftraege();
        for (ResultData resultData : resultDataArray) {
            if (!resultData.hasData()) continue;
            long l = System.currentTimeMillis();
            Data.Array array = resultData.getData().getArray("DeAbrufParameter");
            for (int i = 0; i < array.getLength(); ++i) {
                Data data = array.getItem(i);
                String string = data.getReferenceValue("DeReferenz").getSystemObjectPid();
                int n = data.getUnscaledValue("ID").intValue();
                int n2 = data.getUnscaledValue("Typ").intValue();
                long l2 = data.getTimeValue("Intervall").getMillis();
                boolean bl = data.getTextValue("aktiviert").getText().equals("Ja");
                this.addAuftrag(string, n, n2, l, l2, bl);
            }
        }
        debug.info(String.format("%n=================================================================%nMomentan sind %d Auftr\u00e4ge in der Liste erstellt.%n=================================================================%n", AuftragsListe.getInstanz().holeKopieAuftragsListe().size()));
    }
}

