/*
 * Decompiled with CFR 0.152.
 */
package de.bsvrz.kex.tls.deabruf.par;

import de.bsvrz.sys.funclib.debug.Debug;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CsvLeser {
    private static final Debug debug = Debug.getLogger();
    private String _naechsteZeile = null;
    private char _begrenzungsZeichen;
    private BufferedReader _csvLeser;
    private List<String> _ersteZeile;

    public CsvLeser(Reader reader, char c) {
        this._begrenzungsZeichen = c;
        this._csvLeser = new BufferedReader(reader);
        this._ersteZeile = this.ermitteleSpaltenNamen();
    }

    public void close() {
        try {
            this._csvLeser.close();
        }
        catch (IOException iOException) {
            debug.finest("Datei bereits geschlossen (eventuell schon letzte Zeile eingelesen: " + iOException);
        }
    }

    private List<String> ermitteleSpaltenNamen() {
        List<String> list = null;
        try {
            String string = this._csvLeser.readLine();
            list = this.ermittleZellenEinerZeile(string);
        }
        catch (Exception exception) {
            exception.printStackTrace(System.out);
        }
        return list;
    }

    private List<String> ermittleZellenEinerZeile(String string) {
        Vector<String> vector = new Vector<String>();
        int n = string.length() - 1;
        try {
            for (int i = 0; i <= n; ++i) {
                int n2 = i;
                boolean bl = false;
                while (i <= n) {
                    char c = string.charAt(i);
                    if (c == '\"') {
                        bl = !bl;
                    } else if (c == this._begrenzungsZeichen && !bl) break;
                    ++i;
                }
                int n3 = i;
                if (string.charAt(n2) == '\"' && string.charAt(n3 - 1) == '\"') {
                    ++n2;
                    --n3;
                }
                vector.add(string.substring(n2, n3).replaceAll("\"\"", "\""));
            }
        }
        catch (Exception exception) {
            debug.error("Fehler beim zerlegen einer Zeile der *.csv-Datei: " + exception, (Throwable)exception);
        }
        return vector;
    }

    public List<String> getErsteZeile() {
        return this._ersteZeile;
    }

    public Map<String, String> getNaechsteZeile() {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        if (this.hasNochMehrZeilen()) {
            List<String> list = this.ermittleZellenEinerZeile(this._naechsteZeile.trim());
            for (int i = list.size() - 1; i >= 0; --i) {
                hashMap.put(this._ersteZeile.get(i), list.get(i));
            }
            this._naechsteZeile = "";
        }
        return hashMap;
    }

    public boolean hasNochMehrZeilen() {
        boolean bl;
        try {
            if (this._naechsteZeile == null || this._naechsteZeile.trim().equals("")) {
                this._naechsteZeile = this._csvLeser.readLine();
            }
        }
        catch (Exception exception) {
            debug.finest("Ignorierte Exception beim Einlesen: " + exception);
        }
        if (this._naechsteZeile == null || this._naechsteZeile.trim().equals("")) {
            this.close();
            bl = false;
        } else {
            bl = true;
        }
        return bl;
    }

    public String toString() {
        return "CsvLeser{_begrenzungsZeichen=" + this._begrenzungsZeichen + ", _csvLeser=" + this._csvLeser + ", _ersteZeile=" + this._ersteZeile + ", _naechsteZeile='" + this._naechsteZeile + '\'' + '}';
    }
}

